/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePlaylistLoader;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;

public class DefaultYoutubePlaylistLoader
implements YoutubePlaylistLoader {
    private volatile int playlistPageCount = 6;

    @Override
    public void setPlaylistPageCount(int playlistPageCount) {
        this.playlistPageCount = playlistPageCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AudioPlaylist load(HttpInterface httpInterface, String playlistId, String selectedVideoId, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        HttpGet request = new HttpGet(DefaultYoutubePlaylistLoader.getPlaylistUrl(playlistId) + "&pbj=1&hl=en");
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Invalid status code for playlist response: " + statusCode);
            }
            JsonBrowser json = JsonBrowser.parse(response.getEntity().getContent());
            AudioPlaylist audioPlaylist = this.buildPlaylist(httpInterface, json, selectedVideoId, trackFactory);
            return audioPlaylist;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AudioPlaylist buildPlaylist(HttpInterface httpInterface, JsonBrowser json, String selectedVideoId, Function<AudioTrackInfo, AudioTrack> trackFactory) throws IOException {
        JsonBrowser jsonResponse = json.index(1).get("response");
        JsonBrowser alerts = jsonResponse.get("alerts");
        if (!alerts.isNull()) {
            throw new FriendlyException(alerts.index(0).get("alertRenderer").get("text").get("simpleText").text(), FriendlyException.Severity.COMMON, null);
        }
        JsonBrowser info = jsonResponse.get("sidebar").get("playlistSidebarRenderer").get("items").index(0).get("playlistSidebarPrimaryInfoRenderer");
        String playlistName = info.get("title").get("runs").index(0).get("text").text();
        JsonBrowser playlistVideoList = jsonResponse.get("contents").get("twoColumnBrowseResultsRenderer").get("tabs").index(0).get("tabRenderer").get("content").get("sectionListRenderer").get("contents").index(0).get("itemSectionRenderer").get("contents").index(0).get("playlistVideoListRenderer");
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        String loadMoreUrl = this.extractPlaylistTracks(playlistVideoList, tracks, trackFactory);
        int loadCount = 0;
        int pageCount = this.playlistPageCount;
        while (loadMoreUrl != null && ++loadCount < pageCount) {
            CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com" + loadMoreUrl));
            Throwable throwable = null;
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                    throw new IOException("Invalid status code for playlist response: " + statusCode);
                }
                JsonBrowser continuationJson = JsonBrowser.parse(response.getEntity().getContent());
                JsonBrowser playlistVideoListPage = continuationJson.index(1).get("response").get("continuationContents").get("playlistVideoListContinuation");
                loadMoreUrl = this.extractPlaylistTracks(playlistVideoListPage, tracks, trackFactory);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (response == null) continue;
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                response.close();
            }
        }
        return new BasicAudioPlaylist(playlistName, tracks, this.findSelectedTrack(tracks, selectedVideoId), false);
    }

    private AudioTrack findSelectedTrack(List<AudioTrack> tracks, String selectedVideoId) {
        if (selectedVideoId != null) {
            for (AudioTrack track : tracks) {
                if (!selectedVideoId.equals(track.getIdentifier())) continue;
                return track;
            }
        }
        return null;
    }

    private String extractPlaylistTracks(JsonBrowser playlistVideoList, List<AudioTrack> tracks, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        JsonBrowser trackArray = playlistVideoList.get("contents");
        if (trackArray.isNull()) {
            return null;
        }
        for (JsonBrowser track : trackArray.values()) {
            JsonBrowser item = track.get("playlistVideoRenderer");
            JsonBrowser shortBylineText = item.get("shortBylineText");
            if (item.get("isPlayable").isNull() || shortBylineText.isNull()) continue;
            String videoId = item.get("videoId").text();
            String title = item.get("title").get("simpleText").text();
            String author = shortBylineText.get("runs").index(0).get("text").text();
            long duration = Long.parseLong(item.get("lengthSeconds").text()) * 1000L;
            AudioTrackInfo info = new AudioTrackInfo(title, author, duration, videoId, false, "https://www.youtube.com/watch?v=" + videoId);
            tracks.add(trackFactory.apply(info));
        }
        JsonBrowser continuations = playlistVideoList.get("continuations");
        if (!continuations.isNull()) {
            String continuationsToken = continuations.index(0).get("nextContinuationData").get("continuation").text();
            return "/browse_ajax?continuation=" + continuationsToken + "&ctoken=" + continuationsToken + "&hl=en";
        }
        return null;
    }

    private static String getPlaylistUrl(String playlistId) {
        return "https://www.youtube.com/playlist?list=" + playlistId;
    }
}

