/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackBlueprint;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackLoader;
import com.sedmelluq.discord.lavaplayer.container.playlists.HlsStreamSegment;
import com.sedmelluq.discord.lavaplayer.container.playlists.HlsStreamSegmentParser;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudHelper;
import com.sedmelluq.discord.lavaplayer.tools.http.HttpStreamTools;
import com.sedmelluq.discord.lavaplayer.tools.io.ChainedInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.NonSeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundCloudOpusM3uAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(SoundCloudOpusM3uAudioTrack.class);
    private static final long SEGMENT_UPDATE_INTERVAL = TimeUnit.MINUTES.toMillis(10L);
    private final HttpInterface httpInterface;
    private final String streamLoopupUrl;

    public SoundCloudOpusM3uAudioTrack(AudioTrackInfo trackInfo, HttpInterface httpInterface, String streamLoopupUrl) {
        super(trackInfo);
        this.httpInterface = httpInterface;
        this.streamLoopupUrl = streamLoopupUrl;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (SegmentTracker segmentTracker = this.createSegmentTracker();){
            OggTrackBlueprint blueprint = OggTrackLoader.loadTrackBlueprint(segmentTracker.getOggStream());
            if (blueprint == null) {
                throw new IOException("No OGG track detected in the stream.");
            }
            localExecutor.executeProcessingLoop(() -> {
                try (OggTrackHandler handler = blueprint.loadTrackHandler(segmentTracker.getOggStream());){
                    handler.initialise(localExecutor.getProcessingContext(), segmentTracker.streamStartPosition, segmentTracker.desiredPosition);
                    handler.provideFrames();
                }
            }, x$0 -> segmentTracker.seekToTimecode(x$0), true);
        }
    }

    private List<HlsStreamSegment> loadSegments() throws IOException {
        String playbackUrl = SoundCloudHelper.loadPlaybackUrl(this.httpInterface, this.streamLoopupUrl);
        return HlsStreamSegmentParser.parseFromUrl(this.httpInterface, playbackUrl);
    }

    private SegmentTracker createSegmentTracker() throws IOException {
        List<HlsStreamSegment> initialSegments = this.loadSegments();
        return new SegmentTracker(initialSegments);
    }

    private class SegmentTracker
    implements AutoCloseable {
        private final List<HlsStreamSegment> segments;
        private long desiredPosition = 0L;
        private long streamStartPosition = 0L;
        private long lastUpdate;
        private OggPacketInputStream lastJoinedStream;
        private int segmentIndex = 0;

        private SegmentTracker(List<HlsStreamSegment> segments) {
            this.segments = segments;
            this.lastUpdate = System.currentTimeMillis();
        }

        private OggPacketInputStream getOggStream() {
            if (this.lastJoinedStream == null) {
                this.lastJoinedStream = new OggPacketInputStream(new NonSeekableInputStream(new ChainedInputStream(this::getNextStream)));
            }
            return this.lastJoinedStream;
        }

        private void resetStream() throws IOException {
            if (this.lastJoinedStream != null) {
                this.lastJoinedStream.close();
                this.lastJoinedStream = null;
            }
        }

        private void seekToTimecode(long timecode) throws IOException {
            Long duration;
            long segmentTimecode = 0L;
            for (int i = 0; i < this.segments.size() && (duration = this.segments.get((int)i).duration) != null; ++i) {
                long nextTimecode = segmentTimecode + duration;
                if (timecode >= segmentTimecode && timecode < nextTimecode) {
                    this.seekToSegment(i, timecode, segmentTimecode);
                    return;
                }
                segmentTimecode = nextTimecode;
            }
            this.seekToEnd();
        }

        private void seekToSegment(int index, long requestedTimecode, long segmentTimecode) throws IOException {
            this.resetStream();
            this.segmentIndex = index;
            this.desiredPosition = requestedTimecode;
            this.streamStartPosition = segmentTimecode;
            OggPacketInputStream nextStream = this.getOggStream();
            if (this.streamStartPosition == 0L) {
                OggTrackLoader.loadTrackBlueprint(nextStream);
            } else {
                nextStream.startNewTrack();
            }
        }

        private void seekToEnd() throws IOException {
            this.resetStream();
            this.segmentIndex = this.segments.size();
        }

        private InputStream getNextStream() {
            HlsStreamSegment segment = this.getNextSegment();
            if (segment == null) {
                return null;
            }
            return HttpStreamTools.streamContent(SoundCloudOpusM3uAudioTrack.this.httpInterface, new HttpGet(segment.url));
        }

        private void updateSegmentList() {
            try {
                int i;
                List newSegments = SoundCloudOpusM3uAudioTrack.this.loadSegments();
                if (newSegments.size() != this.segments.size()) {
                    log.error("For {}, received different number of segments on update, skipping.", (Object)((SoundCloudOpusM3uAudioTrack)SoundCloudOpusM3uAudioTrack.this).trackInfo.identifier);
                    return;
                }
                for (i = 0; i < this.segments.size(); ++i) {
                    if (Objects.equals(((HlsStreamSegment)newSegments.get((int)i)).duration, this.segments.get((int)i).duration)) continue;
                    log.error("For {}, segment {} has different length than previously on update.", (Object)((SoundCloudOpusM3uAudioTrack)SoundCloudOpusM3uAudioTrack.this).trackInfo.identifier, (Object)i);
                    return;
                }
                for (i = 0; i < this.segments.size(); ++i) {
                    this.segments.set(i, (HlsStreamSegment)newSegments.get(i));
                }
            }
            catch (Exception e) {
                log.error("For {}, failed to update segment list, skipping.", (Object)((SoundCloudOpusM3uAudioTrack)SoundCloudOpusM3uAudioTrack.this).trackInfo.identifier);
            }
        }

        private void checkSegmentListUpdate() {
            long now = System.currentTimeMillis();
            long delta = now - this.lastUpdate;
            if (delta > SEGMENT_UPDATE_INTERVAL) {
                log.debug("For {}, {}ms has passed since last segment update, updating", (Object)((SoundCloudOpusM3uAudioTrack)SoundCloudOpusM3uAudioTrack.this).trackInfo.identifier, (Object)delta);
                this.updateSegmentList();
                this.lastUpdate = now;
            }
        }

        private HlsStreamSegment getNextSegment() {
            int current;
            if ((current = this.segmentIndex++) < this.segments.size()) {
                this.checkSegmentListUpdate();
                return this.segments.get(current);
            }
            return null;
        }

        @Override
        public void close() throws Exception {
            this.resetStream();
        }
    }
}

