/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.guild.punish;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

public class EffUnbanUser
extends Effect {
    private Expression<Object> users;
    private Expression<Guild> guild;
    private Expression<Object> bot;

    protected void execute(Event e) {
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        Guild guild = (Guild)this.guild.getSingle(e);
        Object[] users = this.users.getAll(e);
        Guild bindedGuild = Util.bindGuild(bot, guild);
        if (users == null || guild == null || bot == null || bindedGuild == null) {
            return;
        }
        for (Object object : users) {
            try {
                String user = object instanceof User ? ((User)object).getId() : (String)object;
                bindedGuild.unban(user).queue();
            }
            catch (PermissionException x) {
                Vixio.getErrorHandler().needsPerm(bot, "unban user", x.getPermission().getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "unban " + this.users.toString(e, debug) + " from " + this.guild.toString(e, debug) + " as " + this.bot.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.users = exprs[0];
        this.guild = exprs[1];
        this.bot = exprs[2];
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffUnbanUser.class, "unban %users/strings% from %guild% [(with|as) %bot/string%]").setName("Unban user from Guild").setDesc("Un-ban a user from a guild as a bot.").setExample("command /ban <text>:", "\ttrigger:", "\t\tunban arg-1 from event-guild");
    }
}

