/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.guild;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.util.Kleenean;
import java.util.HashMap;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.skript.AsyncEffect;
import me.iblitzkriegi.vixio.util.skript.SkriptUtil;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

public class EffCreateInvite
extends AsyncEffect {
    public static HashMap<GuildChannel, Invite> guildInviteHashMap = new HashMap();
    public static Invite lastCreatedInvite;
    private Expression<GuildChannel> channel;
    private Expression<Object> bot;
    private Variable<?> varExpr;
    private VariableString varName;

    protected void execute(Event e) {
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        GuildChannel channel = (GuildChannel)this.channel.getSingle(e);
        if (bot == null || channel == null) {
            return;
        }
        try {
            Invite invite = (Invite)channel.createInvite().complete();
            if (this.varExpr != null) {
                Util.storeInVar(this.varName, this.varExpr, invite.getUrl(), e);
            }
            lastCreatedInvite = invite;
            guildInviteHashMap.put(channel, invite);
        }
        catch (PermissionException x) {
            Vixio.getErrorHandler().needsPerm(bot, "create invite", x.getPermission().getName());
        }
    }

    public String toString(Event e, boolean debug) {
        return "create invite to " + this.channel.toString(e, debug) + " with " + this.bot.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.channel = exprs[0];
        this.bot = exprs[1];
        if (exprs[2] instanceof Variable) {
            this.varExpr = (Variable)exprs[2];
            this.varName = SkriptUtil.getVariableName(this.varExpr);
        }
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffCreateInvite.class, "create a[n] (invite|invitation) to %channel% [with %bot/string%] [and store it in %-objects%]").setName("Create Invite to Guild").setDesc("Create a invitation to a channel. Can store the newly created invite with the storage option or use the last created invite expression.").setExample("discord command invite:", "\ttrigger:", "\t\tcreate an invite to event-channel", "\t\treply with \"%the last created invite%\"");
    }
}

