/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.guild;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.skript.AsyncEffect;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

public class EffCreateEmote
extends AsyncEffect {
    private Expression<String> file;
    private Expression<String> name;
    private Expression<Guild> guild;
    private Expression<Object> bot;

    protected void execute(Event e) {
        String file = (String)this.file.getSingle(e);
        String name = (String)this.name.getSingle(e);
        Guild guild = (Guild)this.guild.getSingle(e);
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        if (file == null || name == null || guild == null || bot == null) {
            return;
        }
        Guild bindedGuild = Util.bindGuild(bot, guild);
        if (bindedGuild == null) {
            return;
        }
        if (Util.isLink(file)) {
            InputStream inputStream = Util.getInputStreamFromUrl(file);
            if (inputStream != null) {
                try {
                    bindedGuild.createEmote(name, Icon.from(inputStream), new Role[0]).queue();
                }
                catch (IOException iOException) {
                }
                catch (PermissionException x) {
                    Vixio.getErrorHandler().needsPerm(bot, "create emote", x.getPermission().getName());
                }
            }
        } else {
            File toSend = new File(file);
            if (toSend.exists()) {
                try {
                    bindedGuild.createEmote(name, Icon.from(toSend), new Role[0]).queue();
                }
                catch (IOException x) {
                }
                catch (PermissionException x) {
                    Vixio.getErrorHandler().needsPerm(bot, "create emote", x.getPermission().getName());
                }
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "create emote " + this.file.toString(e, debug) + " with name " + this.name.toString(e, debug) + " in " + this.guild.toString(e, debug) + " with " + this.bot.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.file = exprs[0];
        this.name = exprs[1];
        this.guild = exprs[2];
        this.bot = exprs[3];
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffCreateEmote.class, "create emote %string% with [the] name %string% [in %guild%] [with %bot/string%]").setName("Create emote").setDesc("Create a emote in a specific guild, the first %string% can either be a direct url or a direct local path to a file.").setExample("discord command $createEmote <text> <text>:", "\ttrigger:", "\t\tcreate emote arg-1 with name arg-2 ", "\t\twait 2 seconds", "\t\treply with \"%reaction arg-2%\"");
    }
}

