/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.guild;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.skript.AsyncEffect;
import me.iblitzkriegi.vixio.util.skript.SkriptUtil;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.exceptions.PermissionException;
import org.bukkit.event.Event;

public class EffCloneChannel
extends AsyncEffect {
    private Expression<GuildChannel> channel;
    private Expression<Guild> guild;
    private Expression<String> name;
    private Expression<Object> bot;
    private Variable<?> varExpr;
    private VariableString varName;

    protected void execute(Event e) {
        Guild guild = (Guild)this.guild.getSingle(e);
        GuildChannel channel = (GuildChannel)this.channel.getSingle(e);
        String name = this.name == null ? null : (String)this.name.getSingle(e);
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        if (bot == null || guild == null || channel == null) {
            return;
        }
        GuildChannel boundChannel = Util.bindChannel(bot, channel);
        if (name == null) {
            name = boundChannel.getName();
        } else if (boundChannel.getType() == ChannelType.TEXT) {
            name.replaceAll(" ", "-");
        }
        Guild boundGuild = Util.bindGuild(bot, guild);
        if (boundChannel == null || boundGuild == null) {
            return;
        }
        try {
            if (this.varExpr == null) {
                boundChannel.createCopy(boundGuild).setName(name).queue();
            } else {
                GuildChannel copiedChannel = (GuildChannel)boundChannel.createCopy(boundGuild).setName(name).complete();
                Util.storeInVar(this.varName, this.varExpr, copiedChannel, e);
            }
        }
        catch (PermissionException x) {
            Vixio.getInstance();
            Vixio.getErrorHandler().needsPerm(bot, "copy channel ", x.getPermission().getName());
        }
    }

    public String toString(Event e, boolean debug) {
        return "clone " + this.channel.toString(e, debug) + " to " + this.guild.toString(e, debug) + (this.name == null ? "" : " with name " + this.name.toString(e, debug)) + " with " + this.bot.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.channel = exprs[0];
        this.guild = exprs[1];
        this.name = exprs[2];
        this.bot = exprs[3];
        if (exprs[4] instanceof Variable) {
            this.varExpr = (Variable)exprs[4];
            this.varName = SkriptUtil.getVariableName(this.varExpr);
        }
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffCloneChannel.class, "clone %channel% [in[to] %guild%] [with [the] [new] name %-string%] [(with|as) %bot/string%] [and store (it|the channel) in %-objects%]").setName("Clone Channel").setDesc("Clone a existing channel into either a new guild or the current guild under a new name.").setExample("clone event-channel with the new name \"Rawr!\"");
    }
}

