/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.twitch;

import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.stream.M3uStreamAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.stream.M3uStreamSegmentUrlProvider;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamSegmentUrlProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchStreamAudioTrack
extends M3uStreamAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(TwitchStreamAudioTrack.class);
    private final TwitchStreamAudioSourceManager sourceManager;
    private final M3uStreamSegmentUrlProvider segmentUrlProvider;

    public TwitchStreamAudioTrack(AudioTrackInfo trackInfo, TwitchStreamAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
        this.segmentUrlProvider = new TwitchStreamSegmentUrlProvider(this.getChannelName(), sourceManager);
    }

    public String getChannelName() {
        return TwitchStreamAudioSourceManager.getChannelIdentifierFromUrl(this.trackInfo.identifier);
    }

    @Override
    protected M3uStreamSegmentUrlProvider getSegmentUrlProvider() {
        return this.segmentUrlProvider;
    }

    @Override
    protected HttpInterface getHttpInterface() {
        return this.sourceManager.getHttpInterface();
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        log.debug("Starting to play Twitch channel {}.", (Object)this.getChannelName());
        super.process(localExecutor);
    }

    @Override
    public AudioTrack makeClone() {
        return new TwitchStreamAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

