/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg.flac;

import com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfo;
import com.sedmelluq.discord.lavaplayer.container.flac.frame.FlacFrameReader;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import com.sedmelluq.discord.lavaplayer.tools.io.BitStreamReader;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.IOException;

public class OggFlacTrackHandler
implements OggTrackHandler {
    private final FlacTrackInfo info;
    private final OggPacketInputStream packetInputStream;
    private final BitStreamReader bitStreamReader;
    private final int[] decodingBuffer;
    private final int[][] rawSampleBuffers;
    private final short[][] sampleBuffers;
    private AudioPipeline downstream;

    public OggFlacTrackHandler(FlacTrackInfo info, OggPacketInputStream packetInputStream) {
        this.info = info;
        this.packetInputStream = packetInputStream;
        this.bitStreamReader = new BitStreamReader(packetInputStream);
        this.decodingBuffer = new int[32];
        this.rawSampleBuffers = new int[info.stream.channelCount][];
        this.sampleBuffers = new short[info.stream.channelCount][];
        for (int i = 0; i < this.rawSampleBuffers.length; ++i) {
            this.rawSampleBuffers[i] = new int[info.stream.maximumBlockSize];
            this.sampleBuffers[i] = new short[info.stream.maximumBlockSize];
        }
    }

    @Override
    public void initialise(AudioProcessingContext context) {
        this.downstream = AudioPipelineFactory.create(context, new PcmFormat(this.info.stream.channelCount, this.info.stream.sampleRate));
    }

    @Override
    public void provideFrames() throws InterruptedException {
        try {
            while (this.packetInputStream.startNewPacket()) {
                int sampleCount = this.readFlacFrame();
                if (sampleCount == 0) {
                    throw new IllegalStateException("Not enough bytes in packet.");
                }
                this.downstream.process(this.sampleBuffers, 0, sampleCount);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readFlacFrame() throws IOException {
        return FlacFrameReader.readFlacFrame(this.packetInputStream, this.bitStreamReader, this.info.stream, this.rawSampleBuffers, this.sampleBuffers, this.decodingBuffer);
    }

    @Override
    public void seekToTimecode(long timecode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.downstream != null) {
            this.downstream.close();
        }
    }
}

