/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.dv8tion.jda.core.audit.ThreadLocalReason;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.ExceptionEvent;
import net.dv8tion.jda.core.events.http.HttpRequestEvent;
import net.dv8tion.jda.core.exceptions.ContextException;
import net.dv8tion.jda.core.exceptions.ErrorResponseException;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.requests.ErrorResponse;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import okhttp3.RequestBody;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class Request<T> {
    private final JDAImpl api;
    private final RestAction<T> restAction;
    private final Consumer<? super T> onSuccess;
    private final Consumer<? super Throwable> onFailure;
    private final BooleanSupplier checks;
    private final boolean shouldQueue;
    private final Route.CompiledRoute route;
    private final RequestBody body;
    private final Object rawBody;
    private final CaseInsensitiveMap<String, String> headers;
    private final String localReason;
    private boolean isCanceled = false;

    public Request(RestAction<T> restAction, Consumer<? super T> onSuccess, Consumer<? super Throwable> onFailure, BooleanSupplier checks, boolean shouldQueue, RequestBody body, Object rawBody, Route.CompiledRoute route, CaseInsensitiveMap<String, String> headers) {
        this.restAction = restAction;
        this.onSuccess = onSuccess;
        this.onFailure = RestAction.isPassContext() ? ContextException.here(onFailure) : onFailure;
        this.checks = checks;
        this.shouldQueue = shouldQueue;
        this.body = body;
        this.rawBody = rawBody;
        this.route = route;
        this.headers = headers;
        this.api = (JDAImpl)restAction.getJDA();
        this.localReason = ThreadLocalReason.getCurrent();
    }

    public void onSuccess(T successObj) {
        this.api.getCallbackPool().execute(() -> {
            block8: {
                try {
                    ThreadLocalReason.Closable __ = ThreadLocalReason.closable(this.localReason);
                    Throwable throwable = null;
                    try {
                        this.onSuccess.accept(successObj);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (__ != null) {
                            Request.$closeResource(throwable, __);
                        }
                    }
                }
                catch (Throwable t) {
                    RestAction.LOG.error("Encountered error while processing success consumer", t);
                    if (!(t instanceof Error)) break block8;
                    this.api.getEventManager().handle(new ExceptionEvent(this.api, t, true));
                }
            }
        });
    }

    public void onFailure(Response response) {
        if (response.code == 429) {
            this.onFailure(new RateLimitedException(this.route, response.retryAfter));
        } else {
            this.onFailure(ErrorResponseException.create(ErrorResponse.fromJSON(response.optObject().orElse(null)), response));
        }
    }

    public void onFailure(Throwable failException) {
        this.api.getCallbackPool().execute(() -> {
            block9: {
                try {
                    ThreadLocalReason.Closable __ = ThreadLocalReason.closable(this.localReason);
                    Throwable throwable = null;
                    try {
                        this.onFailure.accept(failException);
                        if (failException instanceof Error) {
                            this.api.getEventManager().handle(new ExceptionEvent(this.api, failException, false));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (__ != null) {
                            Request.$closeResource(throwable, __);
                        }
                    }
                }
                catch (Throwable t) {
                    RestAction.LOG.error("Encountered error while processing failure consumer", t);
                    if (!(t instanceof Error)) break block9;
                    this.api.getEventManager().handle(new ExceptionEvent(this.api, t, true));
                }
            }
        });
    }

    public JDAImpl getJDA() {
        return this.api;
    }

    public RestAction<T> getRestAction() {
        return this.restAction;
    }

    public Consumer<? super T> getOnSuccess() {
        return this.onSuccess;
    }

    public Consumer<? super Throwable> getOnFailure() {
        return this.onFailure;
    }

    public boolean runChecks() {
        return this.checks == null || this.checks.getAsBoolean();
    }

    public CaseInsensitiveMap<String, String> getHeaders() {
        return this.headers;
    }

    public Route.CompiledRoute getRoute() {
        return this.route;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public Object getRawBody() {
        return this.rawBody;
    }

    public boolean shouldQueue() {
        return this.shouldQueue;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void handleResponse(Response response) {
        this.api.getEventManager().handle(new HttpRequestEvent(this, response));
        this.restAction.handleResponse(response, this);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

