/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.GuildVoiceState;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Icon;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.exceptions.HierarchyException;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.requests.restaction.ChannelAction;
import net.dv8tion.jda.core.requests.restaction.RoleAction;
import net.dv8tion.jda.core.requests.restaction.order.CategoryOrderAction;
import net.dv8tion.jda.core.requests.restaction.order.ChannelOrderAction;
import net.dv8tion.jda.core.requests.restaction.order.RoleOrderAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.PermissionUtil;
import net.dv8tion.jda.core.utils.cache.UpstreamReference;
import org.json.JSONObject;

public class GuildController {
    protected final UpstreamReference<GuildImpl> guild;

    public GuildController(Guild guild) {
        this.guild = new UpstreamReference<GuildImpl>((GuildImpl)guild);
    }

    public Guild getGuild() {
        return this.guild.get();
    }

    public JDA getJDA() {
        return this.getGuild().getJDA();
    }

    @CheckReturnValue
    public RestAction<Void> moveVoiceMember(Member member, VoiceChannel voiceChannel) {
        Checks.notNull(member, "Member");
        Checks.notNull(voiceChannel, "VoiceChannel");
        this.checkGuild(member.getGuild(), "Member");
        this.checkGuild(voiceChannel.getGuild(), "VoiceChannel");
        GuildVoiceState vState = member.getVoiceState();
        if (vState == null) {
            throw new IllegalStateException("Cannot move a Member with disabled CacheFlag.VOICE_STATE");
        }
        if (!vState.inVoiceChannel()) {
            throw new IllegalStateException("You cannot move a Member who isn't in a VoiceChannel!");
        }
        if (!PermissionUtil.checkPermission(vState.getChannel(), this.getGuild().getSelfMember(), Permission.VOICE_MOVE_OTHERS)) {
            throw new InsufficientPermissionException(Permission.VOICE_MOVE_OTHERS, "This account does not have Permission to MOVE_OTHERS out of the channel that the Member is currently in.");
        }
        if (!PermissionUtil.checkPermission(voiceChannel, this.getGuild().getSelfMember(), Permission.VOICE_CONNECT) && !PermissionUtil.checkPermission(voiceChannel, member, Permission.VOICE_CONNECT)) {
            throw new InsufficientPermissionException(Permission.VOICE_CONNECT, "Neither this account nor the Member that is attempting to be moved have the VOICE_CONNECT permission for the destination VoiceChannel, so the move cannot be done.");
        }
        JSONObject body = new JSONObject().put("channel_id", voiceChannel.getId());
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new RestAction<Void>(this.getGuild().getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setNickname(Member member, String nickname) {
        Checks.notNull(member, "Member");
        this.checkGuild(member.getGuild(), "Member");
        if (member.equals(this.getGuild().getSelfMember())) {
            if (!member.hasPermission(Permission.NICKNAME_CHANGE) && !member.hasPermission(Permission.NICKNAME_MANAGE)) {
                throw new InsufficientPermissionException(Permission.NICKNAME_CHANGE, "You neither have NICKNAME_CHANGE nor NICKNAME_MANAGE permission!");
            }
        } else {
            this.checkPermission(Permission.NICKNAME_MANAGE);
            this.checkPosition(member);
        }
        if (Objects.equals(nickname, member.getNickname())) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        if (nickname == null) {
            nickname = "";
        }
        JSONObject body = new JSONObject().put("nick", nickname);
        Route.CompiledRoute route = member.equals(this.getGuild().getSelfMember()) ? Route.Guilds.MODIFY_SELF_NICK.compile(this.getGuild().getId()) : Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new AuditableRestAction<Void>(this.getGuild().getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Integer> prune(int days) {
        this.checkPermission(Permission.KICK_MEMBERS);
        Checks.check(days >= 1, "Days amount must be at minimum 1 day.");
        Route.CompiledRoute route = Route.Guilds.PRUNE_MEMBERS.compile(this.getGuild().getId()).withQueryParams("days", Integer.toString(days));
        return new AuditableRestAction<Integer>(this.getGuild().getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Integer> request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject().getInt("pruned"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(Member member, String reason) {
        Checks.notNull(member, "member");
        this.checkGuild(member.getGuild(), "member");
        this.checkPermission(Permission.KICK_MEMBERS);
        this.checkPosition(member);
        String userId = member.getUser().getId();
        String guildId = this.getGuild().getId();
        Route.CompiledRoute route = Route.Guilds.KICK_MEMBER.compile(guildId, userId);
        if (reason != null && !reason.isEmpty()) {
            route = route.withQueryParams("reason", MiscUtil.encodeUTF8(reason));
        }
        return new AuditableRestAction<Void>(this.getGuild().getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(String userId, String reason) {
        Member member = this.getGuild().getMemberById(userId);
        Checks.check(member != null, "The provided userId does not correspond to a member in this guild! Provided userId: %s", (Object)userId);
        return this.kick(member, reason);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(Member member) {
        return this.kick(member, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(String userId) {
        return this.kick(userId, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(Member member, int delDays, String reason) {
        Checks.notNull(member, "Member");
        return this.ban(member.getUser(), delDays, reason);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(User user, int delDays, String reason) {
        Checks.notNull(user, "User");
        this.checkPermission(Permission.BAN_MEMBERS);
        if (this.getGuild().isMember(user)) {
            this.checkPosition(this.getGuild().getMember(user));
        }
        Checks.notNegative(delDays, "Deletion Days");
        String userId = user.getId();
        Route.CompiledRoute route = Route.Guilds.BAN.compile(this.getGuild().getId(), userId);
        if (reason != null && !reason.isEmpty()) {
            route = route.withQueryParams("reason", MiscUtil.encodeUTF8(reason));
        }
        if (delDays > 0) {
            route = route.withQueryParams("delete-message-days", Integer.toString(delDays));
        }
        return new AuditableRestAction<Void>(this.getGuild().getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(final String userId, int delDays, String reason) {
        this.checkPermission(Permission.BAN_MEMBERS);
        User user = this.getGuild().getJDA().getUserById(userId);
        if (user != null) {
            return this.ban(user, delDays, reason);
        }
        Route.CompiledRoute route = Route.Guilds.BAN.compile(this.getGuild().getId(), userId);
        if (reason != null && !reason.isEmpty()) {
            route = route.withQueryParams("reason", MiscUtil.encodeUTF8(reason));
        }
        if (delDays > 0) {
            route = route.withQueryParams("delete-message-days", Integer.toString(delDays));
        }
        return new AuditableRestAction<Void>(this.getGuild().getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else if (response.code == 404) {
                    request.onFailure(new IllegalArgumentException("User with provided id \"" + userId + "\" does not exist! Cannot ban a non-existent user!"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(Member member, int delDays) {
        return this.ban(member, delDays, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(User user, int delDays) {
        return this.ban(user, delDays, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(String userId, int delDays) {
        return this.ban(userId, delDays, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> unban(User user) {
        Checks.notNull(user, "User");
        return this.unban(user.getId());
    }

    @CheckReturnValue
    public AuditableRestAction<Void> unban(final String userId) {
        Checks.isSnowflake(userId, "User ID");
        this.checkPermission(Permission.BAN_MEMBERS);
        Route.CompiledRoute route = Route.Guilds.UNBAN.compile(this.getGuild().getId(), userId);
        return new AuditableRestAction<Void>(this.getGuild().getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else if (response.code == 404) {
                    request.onFailure(new IllegalArgumentException("User with provided id \"" + userId + "\" is not banned! Cannot unban a user who is not currently banned!"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setDeafen(Member member, boolean deafen) {
        Checks.notNull(member, "Member");
        this.checkGuild(member.getGuild(), "Member");
        this.checkPermission(Permission.VOICE_DEAF_OTHERS);
        if (this.getGuild().getOwner().equals(member)) {
            throw new HierarchyException("Cannot modify Guild Deafen status the Owner of the Guild");
        }
        GuildVoiceState voiceState = member.getVoiceState();
        if (voiceState != null && voiceState.isGuildDeafened() == deafen) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject body = new JSONObject().put("deaf", deafen);
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new AuditableRestAction<Void>(this.getGuild().getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setMute(Member member, boolean mute) {
        Checks.notNull(member, "Member");
        this.checkGuild(member.getGuild(), "Member");
        this.checkPermission(Permission.VOICE_MUTE_OTHERS);
        if (this.getGuild().getOwner().equals(member)) {
            throw new HierarchyException("Cannot modify Guild Mute status the Owner of the Guild");
        }
        GuildVoiceState voiceState = member.getVoiceState();
        if (voiceState != null && voiceState.isGuildMuted() == mute) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject body = new JSONObject().put("mute", mute);
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new AuditableRestAction<Void>(this.getGuild().getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> addSingleRoleToMember(Member member, Role role) {
        Checks.notNull(member, "Member");
        Checks.notNull(role, "Role");
        this.checkGuild(member.getGuild(), "Member");
        this.checkGuild(role.getGuild(), "Role");
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition(role);
        Route.CompiledRoute route = Route.Guilds.ADD_MEMBER_ROLE.compile(this.getGuild().getId(), member.getUser().getId(), role.getId());
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> removeSingleRoleFromMember(Member member, Role role) {
        Checks.notNull(member, "Member");
        Checks.notNull(role, "Role");
        this.checkGuild(member.getGuild(), "Member");
        this.checkGuild(role.getGuild(), "Role");
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition(role);
        Route.CompiledRoute route = Route.Guilds.REMOVE_MEMBER_ROLE.compile(this.getGuild().getId(), member.getUser().getId(), role.getId());
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> addRolesToMember(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Arrays.asList(roles), Collections.emptyList());
    }

    @CheckReturnValue
    public AuditableRestAction<Void> addRolesToMember(Member member, Collection<Role> roles) {
        return this.modifyMemberRoles(member, roles, Collections.emptyList());
    }

    @CheckReturnValue
    public AuditableRestAction<Void> removeRolesFromMember(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Collections.emptyList(), Arrays.asList(roles));
    }

    @CheckReturnValue
    public AuditableRestAction<Void> removeRolesFromMember(Member member, Collection<Role> roles) {
        return this.modifyMemberRoles(member, Collections.emptyList(), roles);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> modifyMemberRoles(Member member, Collection<Role> rolesToAdd, Collection<Role> rolesToRemove) {
        Checks.notNull(member, "Member");
        Checks.notNull(rolesToAdd, "Collection containing roles to be added to the member");
        Checks.notNull(rolesToRemove, "Collection containing roles to be removed from the member");
        this.checkGuild(member.getGuild(), "Member");
        this.checkPermission(Permission.MANAGE_ROLES);
        rolesToAdd.forEach(role -> {
            Checks.notNull(role, "Role in rolesToAdd");
            this.checkGuild(role.getGuild(), "Role: " + role.toString());
            this.checkPosition((Role)role);
            Checks.check(!role.isManaged(), "Cannot add a Managed role to a Member. Role: %s", (Object)role.toString());
        });
        rolesToRemove.forEach(role -> {
            Checks.notNull(role, "Role in rolesToRemove");
            this.checkGuild(role.getGuild(), "Role: " + role.toString());
            this.checkPosition((Role)role);
            Checks.check(!role.isManaged(), "Cannot remove a Managed role from a Member. Role: %s", (Object)role.toString());
        });
        HashSet<Role> currentRoles = new HashSet<Role>(((MemberImpl)member).getRoleSet());
        HashSet<Role> newRolesToAdd = new HashSet<Role>(rolesToAdd);
        newRolesToAdd.removeAll(rolesToRemove);
        if (currentRoles.addAll(newRolesToAdd)) {
            currentRoles.removeAll(rolesToRemove);
        } else if (!currentRoles.removeAll(rolesToRemove)) {
            return new AuditableRestAction.EmptyRestAction<Void>(this.getGuild().getJDA());
        }
        Checks.check(!currentRoles.contains(this.getGuild().getPublicRole()), "Cannot add the PublicRole of a Guild to a Member. All members have this role by default!");
        JSONObject body = new JSONObject().put("roles", currentRoles.stream().map(ISnowflake::getId).collect(Collectors.toList()));
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new AuditableRestAction<Void>(this.getGuild().getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> modifyMemberRoles(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Arrays.asList(roles));
    }

    @CheckReturnValue
    public AuditableRestAction<Void> modifyMemberRoles(Member member, Collection<Role> roles) {
        Checks.notNull(member, "Member");
        Checks.notNull(roles, "Roles");
        this.checkGuild(member.getGuild(), "Member");
        roles.forEach(role -> {
            Checks.notNull(role, "Role in collection");
            this.checkGuild(role.getGuild(), "Role: " + role.toString());
            this.checkPosition((Role)role);
        });
        Checks.check(!roles.contains(this.getGuild().getPublicRole()), "Cannot add the PublicRole of a Guild to a Member. All members have this role by default!");
        List<Role> memberRoles = member.getRoles();
        if (memberRoles.size() == roles.size() && memberRoles.containsAll(roles)) {
            return new AuditableRestAction.EmptyRestAction<Void>(this.getGuild().getJDA());
        }
        List currentManaged = memberRoles.stream().filter(Role::isManaged).collect(Collectors.toList());
        List newManaged = roles.stream().filter(Role::isManaged).collect(Collectors.toList());
        if (!currentManaged.isEmpty() || !newManaged.isEmpty()) {
            if (!newManaged.containsAll(currentManaged)) {
                currentManaged.removeAll(newManaged);
                throw new IllegalArgumentException("Cannot remove managed roles from a member! Roles: " + currentManaged.toString());
            }
            if (!currentManaged.containsAll(newManaged)) {
                newManaged.removeAll(currentManaged);
                throw new IllegalArgumentException("Cannot add managed roles to a member! Roles: " + newManaged.toString());
            }
        }
        JSONObject body = new JSONObject().put("roles", roles.stream().map(ISnowflake::getId).collect(Collectors.toList()));
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.getGuild().getId(), member.getUser().getId());
        return new AuditableRestAction<Void>(this.getGuild().getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> transferOwnership(Member newOwner) {
        Checks.notNull(newOwner, "Member");
        this.checkGuild(newOwner.getGuild(), "Member");
        if (!this.getGuild().getOwner().equals(this.getGuild().getSelfMember())) {
            throw new PermissionException("The logged in account must be the owner of this Guild to be able to transfer ownership");
        }
        Checks.check(!this.getGuild().getSelfMember().equals(newOwner), "The member provided as the newOwner is the currently logged in account. Provide a different member to give ownership to.");
        Checks.check(!newOwner.getUser().isBot(), "Cannot transfer ownership of a Guild to a Bot!");
        JSONObject body = new JSONObject().put("owner_id", newOwner.getUser().getId());
        Route.CompiledRoute route = Route.Guilds.MODIFY_GUILD.compile(this.getGuild().getId());
        return new AuditableRestAction<Void>(this.getGuild().getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public ChannelAction createTextChannel(String name) {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Checks.notBlank(name, "Name");
        name = name.trim();
        Checks.check(name.length() > 0 && name.length() <= 100, "Provided name must be 1 - 100 characters in length");
        Route.CompiledRoute route = Route.Guilds.CREATE_CHANNEL.compile(this.getGuild().getId());
        return new ChannelAction(route, name, this.getGuild(), ChannelType.TEXT);
    }

    @CheckReturnValue
    public ChannelAction createVoiceChannel(String name) {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Checks.notBlank(name, "Name");
        name = name.trim();
        Checks.check(name.length() > 0 && name.length() <= 100, "Provided name must be 1 - 100 characters in length");
        Route.CompiledRoute route = Route.Guilds.CREATE_CHANNEL.compile(this.getGuild().getId());
        return new ChannelAction(route, name, this.getGuild(), ChannelType.VOICE);
    }

    @CheckReturnValue
    public ChannelAction createCategory(String name) {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Checks.notBlank(name, "Name");
        name = name.trim();
        Checks.check(name.length() > 0 && name.length() <= 100, "Provided name must be 1 - 100 characters in length");
        Route.CompiledRoute route = Route.Guilds.CREATE_CHANNEL.compile(this.getGuild().getId());
        return new ChannelAction(route, name, this.getGuild(), ChannelType.CATEGORY);
    }

    @CheckReturnValue
    public ChannelAction createCopyOfChannel(Channel channel) {
        Checks.notNull(channel, "Channel");
        return channel.createCopy(this.getGuild());
    }

    @CheckReturnValue
    public RoleAction createRole() {
        this.checkPermission(Permission.MANAGE_ROLES);
        Route.CompiledRoute route = Route.Roles.CREATE_ROLE.compile(this.getGuild().getId());
        return new RoleAction(route, this.getGuild());
    }

    @CheckReturnValue
    public RoleAction createCopyOfRole(Role role) {
        Checks.notNull(role, "Role");
        return role.createCopy(this.getGuild());
    }

    @CheckReturnValue
    public AuditableRestAction<Emote> createEmote(String name, Icon icon, Role ... roles) {
        this.checkPermission(Permission.MANAGE_EMOTES);
        Checks.notBlank(name, "Emote name");
        Checks.notNull(icon, "Emote icon");
        Checks.notNull(roles, "Roles");
        JSONObject body = new JSONObject();
        body.put("name", name);
        body.put("image", icon.getEncoding());
        if (roles.length > 0) {
            body.put("roles", Stream.of(roles).filter(Objects::nonNull).map(ISnowflake::getId).collect(Collectors.toSet()));
        }
        Route.CompiledRoute route = Route.Emotes.CREATE_EMOTE.compile(this.getGuild().getId());
        return new AuditableRestAction<Emote>(this.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Emote> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                JSONObject obj = response.getObject();
                EmoteImpl emote = ((JDAImpl)this.api.get()).getEntityBuilder().createEmote((GuildImpl)GuildController.this.getGuild(), obj, true);
                request.onSuccess(emote);
            }
        };
    }

    @CheckReturnValue
    public ChannelOrderAction<Category> modifyCategoryPositions() {
        return new ChannelOrderAction<Category>(this.getGuild(), ChannelType.CATEGORY);
    }

    @CheckReturnValue
    public ChannelOrderAction<TextChannel> modifyTextChannelPositions() {
        return new ChannelOrderAction<TextChannel>(this.getGuild(), ChannelType.TEXT);
    }

    @CheckReturnValue
    public ChannelOrderAction<VoiceChannel> modifyVoiceChannelPositions() {
        return new ChannelOrderAction<VoiceChannel>(this.getGuild(), ChannelType.VOICE);
    }

    @CheckReturnValue
    public CategoryOrderAction<TextChannel> modifyTextChannelPositions(Category category) {
        Checks.notNull(category, "Category");
        this.checkGuild(category.getGuild(), "Category");
        return new CategoryOrderAction<TextChannel>(category, ChannelType.TEXT);
    }

    @CheckReturnValue
    public CategoryOrderAction<VoiceChannel> modifyVoiceChannelPositions(Category category) {
        Checks.notNull(category, "Category");
        this.checkGuild(category.getGuild(), "Category");
        return new CategoryOrderAction<VoiceChannel>(category, ChannelType.VOICE);
    }

    @CheckReturnValue
    public RoleOrderAction modifyRolePositions() {
        return this.modifyRolePositions(true);
    }

    @CheckReturnValue
    public RoleOrderAction modifyRolePositions(boolean useDiscordOrder) {
        return new RoleOrderAction(this.getGuild(), useDiscordOrder);
    }

    protected void checkGuild(Guild providedGuild, String comment) {
        if (!this.getGuild().equals(providedGuild)) {
            throw new IllegalArgumentException("Provided " + comment + " is not part of this Guild!");
        }
    }

    protected void checkPermission(Permission perm) {
        if (!this.getGuild().getSelfMember().hasPermission(perm)) {
            throw new InsufficientPermissionException(perm);
        }
    }

    protected void checkPosition(Member member) {
        if (!this.getGuild().getSelfMember().canInteract(member)) {
            throw new HierarchyException("Can't modify a member with higher or equal highest role than yourself!");
        }
    }

    protected void checkPosition(Role role) {
        if (!this.getGuild().getSelfMember().canInteract(role)) {
            throw new HierarchyException("Can't modify a role with higher or equal highest role than yourself! Role: " + role.toString());
        }
    }
}

