/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.utils.cache.UpstreamReference;
import org.json.JSONObject;

public abstract class SocketHandler {
    protected final UpstreamReference<JDAImpl> api;
    protected long responseNumber;
    protected JSONObject allContent;

    public SocketHandler(JDAImpl api) {
        this.api = new UpstreamReference<JDAImpl>(api);
    }

    public final synchronized void handle(long responseTotal, JSONObject o) {
        this.allContent = o;
        this.responseNumber = responseTotal;
        Long guildId = this.handleInternally(o.getJSONObject("d"));
        if (guildId != null) {
            this.getJDA().getGuildSetupController().cacheEvent(guildId, o);
        }
        this.allContent = null;
    }

    protected JDAImpl getJDA() {
        return this.api.get();
    }

    protected abstract Long handleInternally(JSONObject var1);

    public static class NOPHandler
    extends SocketHandler {
        public NOPHandler(JDAImpl api) {
            super(api);
        }

        @Override
        protected Long handleInternally(JSONObject content) {
            return null;
        }
    }
}

