/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import gnu.trove.map.TLongObjectMap;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.client.requests.restaction.pagination.MentionPaginationAction;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.Region;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.GuildVoiceState;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.ListedEmote;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.WebhookImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.managers.GuildController;
import net.dv8tion.jda.core.managers.GuildManager;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.MemberAction;
import net.dv8tion.jda.core.requests.restaction.pagination.AuditLogPaginationAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.Helpers;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.cache.MemberCacheView;
import net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.core.utils.cache.UpstreamReference;
import net.dv8tion.jda.core.utils.cache.impl.MemberCacheViewImpl;
import net.dv8tion.jda.core.utils.cache.impl.SnowflakeCacheViewImpl;
import net.dv8tion.jda.core.utils.cache.impl.SortedSnowflakeCacheView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GuildImpl
implements Guild {
    private final long id;
    private final UpstreamReference<JDAImpl> api;
    private final SortedSnowflakeCacheView<Category> categoryCache = new SortedSnowflakeCacheView<Category>(Category.class, Channel::getName, Comparator.naturalOrder());
    private final SortedSnowflakeCacheView<VoiceChannel> voiceChannelCache = new SortedSnowflakeCacheView<VoiceChannel>(VoiceChannel.class, Channel::getName, Comparator.naturalOrder());
    private final SortedSnowflakeCacheView<TextChannel> textChannelCache = new SortedSnowflakeCacheView<TextChannel>(TextChannel.class, Channel::getName, Comparator.naturalOrder());
    private final SortedSnowflakeCacheView<Role> roleCache = new SortedSnowflakeCacheView<Role>(Role.class, Role::getName, Comparator.reverseOrder());
    private final SnowflakeCacheViewImpl<Emote> emoteCache = new SnowflakeCacheViewImpl<Emote>(Emote.class, Emote::getName);
    private final MemberCacheViewImpl memberCache = new MemberCacheViewImpl();
    private final TLongObjectMap<JSONObject> cachedPresences = MiscUtil.newLongMap();
    private final ReentrantLock mngLock = new ReentrantLock();
    private volatile GuildManager manager;
    private volatile GuildController controller;
    private Member owner;
    private String name;
    private String iconId;
    private String splashId;
    private String region;
    private long ownerId;
    private Set<String> features;
    private VoiceChannel afkChannel;
    private TextChannel systemChannel;
    private Role publicRole;
    private Guild.VerificationLevel verificationLevel;
    private Guild.NotificationLevel defaultNotificationLevel;
    private Guild.MFALevel mfaLevel;
    private Guild.ExplicitContentLevel explicitContentLevel;
    private Guild.Timeout afkTimeout;
    private boolean available;
    private boolean canSendVerification = false;

    public GuildImpl(JDAImpl api, long id) {
        this.id = id;
        this.api = new UpstreamReference<JDAImpl>(api);
    }

    @Override
    public RestAction<EnumSet<Region>> retrieveRegions(final boolean includeDeprecated) {
        Route.CompiledRoute route = Route.Guilds.GET_VOICE_REGIONS.compile(this.getId());
        return new RestAction<EnumSet<Region>>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<EnumSet<Region>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EnumSet<Region> set = EnumSet.noneOf(Region.class);
                JSONArray arr = response.getArray();
                for (int i = 0; arr != null && i < arr.length(); ++i) {
                    String id;
                    Region region;
                    JSONObject obj = arr.getJSONObject(i);
                    if (!includeDeprecated && Helpers.optBoolean(obj, "deprecated") || (region = Region.fromKey(id = obj.optString("id"))) == Region.UNKNOWN) continue;
                    set.add(region);
                }
                request.onSuccess(set);
            }
        };
    }

    @Override
    public MemberAction addMember(String accessToken, String userId) {
        Checks.notBlank(accessToken, "Access-Token");
        Checks.isSnowflake(userId, "User ID");
        Checks.check(this.getMemberById(userId) == null, "User is already in this guild");
        if (!this.getSelfMember().hasPermission(Permission.CREATE_INSTANT_INVITE)) {
            throw new InsufficientPermissionException(Permission.CREATE_INSTANT_INVITE);
        }
        return new MemberAction(this.getJDA(), this, userId, accessToken);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/icons/" + this.id + "/" + this.iconId + ".png";
    }

    @Override
    public Set<String> getFeatures() {
        return this.features;
    }

    @Override
    public String getSplashId() {
        return this.splashId;
    }

    @Override
    public String getSplashUrl() {
        return this.splashId == null ? null : "https://cdn.discordapp.com/splashes/" + this.id + "/" + this.splashId + ".png";
    }

    @Override
    public RestAction<String> getVanityUrl() {
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_SERVER)) {
            throw new InsufficientPermissionException(Permission.MANAGE_SERVER);
        }
        if (!this.getFeatures().contains("VANITY_URL")) {
            throw new IllegalStateException("This guild doesn't have a vanity url");
        }
        Route.CompiledRoute route = Route.Guilds.GET_VANITY_URL.compile(this.getId());
        return new RestAction<String>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<String> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                request.onSuccess(response.getObject().getString("code"));
            }
        };
    }

    @Override
    public VoiceChannel getAfkChannel() {
        return this.afkChannel;
    }

    @Override
    public TextChannel getSystemChannel() {
        return this.systemChannel;
    }

    @Override
    public RestAction<List<Webhook>> getWebhooks() {
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_WEBHOOKS);
        }
        Route.CompiledRoute route = Route.Guilds.GET_WEBHOOKS.compile(this.getId());
        return new RestAction<List<Webhook>>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Webhook>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                JSONArray array = response.getArray();
                ArrayList<WebhookImpl> webhooks = new ArrayList<WebhookImpl>(array.length());
                EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
                for (Object object : array) {
                    try {
                        webhooks.add(builder.createWebhook((JSONObject)object));
                    }
                    catch (NullPointerException | JSONException e) {
                        JDAImpl.LOG.error("Error creating webhook from json", e);
                    }
                }
                request.onSuccess(Collections.unmodifiableList(webhooks));
            }
        };
    }

    @Override
    public Member getOwner() {
        return this.owner;
    }

    @Override
    public long getOwnerIdLong() {
        return this.ownerId;
    }

    @Override
    public Guild.Timeout getAfkTimeout() {
        return this.afkTimeout;
    }

    @Override
    public String getRegionRaw() {
        return this.region;
    }

    @Override
    public boolean isMember(User user) {
        return this.memberCache.getMap().containsKey(user.getIdLong());
    }

    @Override
    public Member getSelfMember() {
        return this.getMember(this.getJDA().getSelfUser());
    }

    @Override
    public Member getMember(User user) {
        return this.getMemberById(user.getIdLong());
    }

    @Override
    public MemberCacheView getMemberCache() {
        return this.memberCache;
    }

    @Override
    public SnowflakeCacheView<Category> getCategoryCache() {
        return this.categoryCache;
    }

    @Override
    public SnowflakeCacheView<TextChannel> getTextChannelCache() {
        return this.textChannelCache;
    }

    @Override
    public SnowflakeCacheView<VoiceChannel> getVoiceChannelCache() {
        return this.voiceChannelCache;
    }

    @Override
    public SnowflakeCacheView<Role> getRoleCache() {
        return this.roleCache;
    }

    @Override
    public SnowflakeCacheView<Emote> getEmoteCache() {
        return this.emoteCache;
    }

    @Override
    public RestAction<List<ListedEmote>> retrieveEmotes() {
        Route.CompiledRoute route = Route.Emotes.GET_EMOTES.compile(this.getId());
        return new RestAction<List<ListedEmote>>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<ListedEmote>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EntityBuilder builder = GuildImpl.this.getJDA().getEntityBuilder();
                JSONArray emotes = response.getArray();
                ArrayList<EmoteImpl> list = new ArrayList<EmoteImpl>(emotes.length());
                for (int i = 0; i < emotes.length(); ++i) {
                    JSONObject emote = emotes.getJSONObject(i);
                    list.add(builder.createEmote(GuildImpl.this, emote, true));
                }
                request.onSuccess(Collections.unmodifiableList(list));
            }
        };
    }

    @Override
    public RestAction<ListedEmote> retrieveEmoteById(String id) {
        ListedEmote listedEmote;
        Checks.isSnowflake(id, "Emote ID");
        Emote emote = this.getEmoteById(id);
        if (emote != null && ((listedEmote = (ListedEmote)emote).hasUser() || !this.getSelfMember().hasPermission(Permission.MANAGE_EMOTES))) {
            return new RestAction.EmptyRestAction<ListedEmote>((JDA)this.getJDA(), listedEmote);
        }
        Route.CompiledRoute route = Route.Emotes.GET_EMOTE.compile(this.getId(), id);
        return new RestAction<ListedEmote>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<ListedEmote> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EntityBuilder builder = GuildImpl.this.getJDA().getEntityBuilder();
                EmoteImpl emote = builder.createEmote(GuildImpl.this, response.getObject(), true);
                request.onSuccess(emote);
            }
        };
    }

    @Override
    @Nonnull
    public RestAction<List<Guild.Ban>> getBanList() {
        if (!this.getSelfMember().hasPermission(Permission.BAN_MEMBERS)) {
            throw new InsufficientPermissionException(Permission.BAN_MEMBERS);
        }
        Route.CompiledRoute route = Route.Guilds.GET_BANS.compile(this.getId());
        return new RestAction<List<Guild.Ban>>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Guild.Ban>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
                LinkedList<Guild.Ban> bans = new LinkedList<Guild.Ban>();
                JSONArray bannedArr = response.getArray();
                for (int i = 0; i < bannedArr.length(); ++i) {
                    JSONObject object = bannedArr.getJSONObject(i);
                    JSONObject user = object.getJSONObject("user");
                    bans.add(new Guild.Ban(builder.createFakeUser(user, false), object.optString("reason", null)));
                }
                request.onSuccess(Collections.unmodifiableList(bans));
            }
        };
    }

    @Override
    @Nonnull
    public RestAction<Guild.Ban> getBanById(@Nonnull String userId) {
        if (!this.getSelfMember().hasPermission(Permission.BAN_MEMBERS)) {
            throw new InsufficientPermissionException(Permission.BAN_MEMBERS);
        }
        Checks.isSnowflake(userId, "User ID");
        Route.CompiledRoute route = Route.Guilds.GET_BAN.compile(this.getId(), userId);
        return new RestAction<Guild.Ban>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Guild.Ban> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
                JSONObject bannedObj = response.getObject();
                JSONObject user = bannedObj.getJSONObject("user");
                Guild.Ban ban = new Guild.Ban(builder.createFakeUser(user, false), bannedObj.optString("reason", null));
                request.onSuccess(ban);
            }
        };
    }

    @Override
    public RestAction<Integer> getPrunableMemberCount(int days) {
        if (!this.getSelfMember().hasPermission(Permission.KICK_MEMBERS)) {
            throw new InsufficientPermissionException(Permission.KICK_MEMBERS);
        }
        if (days < 1) {
            throw new IllegalArgumentException("Days amount must be at minimum 1 day.");
        }
        Route.CompiledRoute route = Route.Guilds.PRUNABLE_COUNT.compile(this.getId()).withQueryParams("days", Integer.toString(days));
        return new RestAction<Integer>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Integer> request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject().getInt("pruned"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public Role getPublicRole() {
        return this.publicRole;
    }

    @Override
    @Nullable
    public TextChannel getDefaultChannel() {
        Role role = this.getPublicRole();
        return this.getTextChannelsMap().valueCollection().stream().filter(c -> role.hasPermission((Channel)c, Permission.MESSAGE_READ)).sorted(Comparator.naturalOrder()).findFirst().orElse(null);
    }

    @Override
    public GuildManager getManager() {
        GuildManager mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new GuildManager(this);
                }
                return this.manager;
            });
        }
        return mng;
    }

    @Override
    public GuildController getController() {
        GuildController ctrl = this.controller;
        if (ctrl == null) {
            ctrl = MiscUtil.locked(this.mngLock, () -> {
                if (this.controller == null) {
                    this.controller = new GuildController(this);
                }
                return this.controller;
            });
        }
        return ctrl;
    }

    @Override
    public MentionPaginationAction getRecentMentions() {
        AccountTypeException.check(this.getJDA().getAccountType(), AccountType.CLIENT);
        return this.getJDA().asClient().getRecentMentions(this);
    }

    @Override
    public AuditLogPaginationAction getAuditLogs() {
        return new AuditLogPaginationAction(this);
    }

    @Override
    public RestAction<Void> leave() {
        if (this.owner.equals(this.getSelfMember())) {
            throw new IllegalStateException("Cannot leave a guild that you are the owner of! Transfer guild ownership first!");
        }
        Route.CompiledRoute route = Route.Self.LEAVE_GUILD.compile(this.getId());
        return new RestAction<Void>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> delete() {
        if (!this.getJDA().getSelfUser().isBot() && this.getJDA().getSelfUser().isMfaEnabled()) {
            throw new IllegalStateException("Cannot delete a guild without providing MFA code. Use Guild#delete(String)");
        }
        return this.delete(null);
    }

    @Override
    public RestAction<Void> delete(String mfaCode) {
        if (!this.owner.equals(this.getSelfMember())) {
            throw new PermissionException("Cannot delete a guild that you do not own!");
        }
        JSONObject mfaBody = null;
        if (!this.getJDA().getSelfUser().isBot() && this.getJDA().getSelfUser().isMfaEnabled()) {
            Checks.notEmpty(mfaCode, "Provided MultiFactor Auth code");
            mfaBody = new JSONObject().put("code", mfaCode);
        }
        Route.CompiledRoute route = Route.Guilds.DELETE_GUILD.compile(this.getId());
        return new RestAction<Void>((JDA)this.getJDA(), route, mfaBody){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioManager getAudioManager() {
        if (!this.getJDA().isAudioEnabled()) {
            throw new IllegalStateException("Audio is disabled. Cannot retrieve an AudioManager while audio is disabled.");
        }
        TLongObjectMap<AudioManager> managerMap = this.getJDA().getAudioManagerMap();
        AudioManager mng = managerMap.get(this.id);
        if (mng == null) {
            TLongObjectMap<AudioManager> tLongObjectMap = managerMap;
            synchronized (tLongObjectMap) {
                GuildImpl cachedGuild = (GuildImpl)this.getJDA().getGuildById(this.id);
                if (cachedGuild == null) {
                    throw new IllegalStateException("Cannot get an AudioManager instance on an uncached Guild");
                }
                mng = managerMap.get(this.id);
                if (mng == null) {
                    mng = new AudioManagerImpl(cachedGuild);
                    managerMap.put(this.id, mng);
                }
            }
        }
        return mng;
    }

    @Override
    public JDAImpl getJDA() {
        return this.api.get();
    }

    @Override
    public List<GuildVoiceState> getVoiceStates() {
        return Collections.unmodifiableList(this.getMembersMap().valueCollection().stream().map(Member::getVoiceState).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public Guild.VerificationLevel getVerificationLevel() {
        return this.verificationLevel;
    }

    @Override
    public Guild.NotificationLevel getDefaultNotificationLevel() {
        return this.defaultNotificationLevel;
    }

    @Override
    public Guild.MFALevel getRequiredMFALevel() {
        return this.mfaLevel;
    }

    @Override
    public Guild.ExplicitContentLevel getExplicitContentLevel() {
        return this.explicitContentLevel;
    }

    @Override
    public boolean checkVerification() {
        if (this.getJDA().getAccountType() == AccountType.BOT) {
            return true;
        }
        if (this.canSendVerification) {
            return true;
        }
        if (this.getJDA().getSelfUser().getPhoneNumber() != null) {
            this.canSendVerification = true;
            return true;
        }
        switch (this.verificationLevel) {
            case VERY_HIGH: {
                break;
            }
            case HIGH: {
                if (ChronoUnit.MINUTES.between(this.getSelfMember().getJoinDate(), OffsetDateTime.now()) < 10L) break;
            }
            case MEDIUM: {
                if (ChronoUnit.MINUTES.between(MiscUtil.getCreationTime(this.getJDA().getSelfUser()), OffsetDateTime.now()) < 5L) break;
            }
            case LOW: {
                if (!this.getJDA().getSelfUser().isVerified()) break;
            }
            case NONE: {
                this.canSendVerification = true;
                return true;
            }
            case UNKNOWN: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public GuildImpl setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public GuildImpl setOwner(Member owner) {
        this.owner = owner;
        return this;
    }

    public GuildImpl setName(String name) {
        this.name = name;
        return this;
    }

    public GuildImpl setIconId(String iconId) {
        this.iconId = iconId;
        return this;
    }

    public GuildImpl setFeatures(Set<String> features) {
        this.features = Collections.unmodifiableSet(features);
        return this;
    }

    public GuildImpl setSplashId(String splashId) {
        this.splashId = splashId;
        return this;
    }

    public GuildImpl setRegion(String region) {
        this.region = region;
        return this;
    }

    public GuildImpl setAfkChannel(VoiceChannel afkChannel) {
        this.afkChannel = afkChannel;
        return this;
    }

    public GuildImpl setSystemChannel(TextChannel systemChannel) {
        this.systemChannel = systemChannel;
        return this;
    }

    public GuildImpl setPublicRole(Role publicRole) {
        this.publicRole = publicRole;
        return this;
    }

    public GuildImpl setVerificationLevel(Guild.VerificationLevel level) {
        this.verificationLevel = level;
        this.canSendVerification = false;
        return this;
    }

    public GuildImpl setDefaultNotificationLevel(Guild.NotificationLevel level) {
        this.defaultNotificationLevel = level;
        return this;
    }

    public GuildImpl setRequiredMFALevel(Guild.MFALevel level) {
        this.mfaLevel = level;
        return this;
    }

    public GuildImpl setExplicitContentLevel(Guild.ExplicitContentLevel level) {
        this.explicitContentLevel = level;
        return this;
    }

    public GuildImpl setAfkTimeout(Guild.Timeout afkTimeout) {
        this.afkTimeout = afkTimeout;
        return this;
    }

    public GuildImpl setOwnerId(long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public TLongObjectMap<Category> getCategoriesMap() {
        return this.categoryCache.getMap();
    }

    public TLongObjectMap<TextChannel> getTextChannelsMap() {
        return this.textChannelCache.getMap();
    }

    public TLongObjectMap<VoiceChannel> getVoiceChannelsMap() {
        return this.voiceChannelCache.getMap();
    }

    public TLongObjectMap<Member> getMembersMap() {
        return this.memberCache.getMap();
    }

    public TLongObjectMap<Role> getRolesMap() {
        return this.roleCache.getMap();
    }

    public TLongObjectMap<Emote> getEmoteMap() {
        return this.emoteCache.getMap();
    }

    public TLongObjectMap<JSONObject> getCachedPresenceMap() {
        return this.cachedPresences;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GuildImpl)) {
            return false;
        }
        GuildImpl oGuild = (GuildImpl)o;
        return this == oGuild || this.id == oGuild.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "G:" + this.getName() + '(' + this.id + ')';
    }

    @Override
    public RestAction<List<Invite>> getInvites() {
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_SERVER)) {
            throw new InsufficientPermissionException(Permission.MANAGE_SERVER);
        }
        Route.CompiledRoute route = Route.Invites.GET_GUILD_INVITES.compile(this.getId());
        return new RestAction<List<Invite>>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Invite>> request) {
                if (response.isOk()) {
                    EntityBuilder entityBuilder = ((JDAImpl)this.api.get()).getEntityBuilder();
                    JSONArray array = response.getArray();
                    ArrayList<Invite> invites = new ArrayList<Invite>(array.length());
                    for (int i = 0; i < array.length(); ++i) {
                        invites.add(entityBuilder.createInvite(array.getJSONObject(i)));
                    }
                    request.onSuccess(Collections.unmodifiableList(invites));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }
}

