/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.retrieve.channel;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Set;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import org.bukkit.event.Event;

public class ExprChannelWithId
extends SimpleExpression<Channel> {
    private Expression<String> id;
    private Expression<Guild> guild;

    protected Channel[] get(Event e) {
        Channel[] channelArray;
        String id = (String)this.id.getSingle(e);
        if (id == null || id.isEmpty()) {
            return null;
        }
        if (!id.matches("-?\\d+(.\\d+)?")) {
            return null;
        }
        if (this.guild == null) {
            Channel[] channelArray2;
            Set<JDA> jdaInstances = Vixio.getInstance().botHashMap.keySet();
            if (jdaInstances.isEmpty()) {
                return null;
            }
            ArrayList<Comparable<TextChannel>> channels = new ArrayList<Comparable<TextChannel>>();
            for (JDA jda : jdaInstances) {
                TextChannel textChannel = jda.getTextChannelById(id);
                VoiceChannel voiceChannel = jda.getVoiceChannelById(id);
                if (textChannel != null) {
                    channels.add(textChannel);
                    continue;
                }
                if (voiceChannel == null) continue;
                channels.add(voiceChannel);
            }
            if (channels.isEmpty()) {
                channelArray2 = null;
            } else {
                Channel[] channelArray3 = new Channel[1];
                channelArray2 = channelArray3;
                channelArray3[0] = (Channel)channels.get(0);
            }
            return channelArray2;
        }
        Guild guild = (Guild)this.guild.getSingle(e);
        if (guild == null) {
            return null;
        }
        TextChannel textChannel = guild.getTextChannelById(id);
        VoiceChannel voiceChannel = guild.getVoiceChannelById(id);
        ArrayList<Comparable<TextChannel>> channels = new ArrayList<Comparable<TextChannel>>();
        if (textChannel != null) {
            channels.add(textChannel);
        } else if (voiceChannel != null) {
            channels.add(voiceChannel);
        }
        if (channels.isEmpty()) {
            channelArray = null;
        } else {
            Channel[] channelArray4 = new Channel[1];
            channelArray = channelArray4;
            channelArray4[0] = (Channel)channels.get(0);
        }
        return channelArray;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Channel> getReturnType() {
        return Channel.class;
    }

    public String toString(Event e, boolean debug) {
        return "channel with id " + this.id.toString(e, debug) + (this.guild == null ? "" : " in " + this.guild.toString(e, debug));
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.id = exprs[0];
        this.guild = exprs[1];
        return true;
    }

    static {
        Vixio.getInstance().registerExpression(ExprChannelWithId.class, Channel.class, ExpressionType.SIMPLE, "channel with id %string% [in %-guild%]").setName("Channel with ID").setDesc("Grabs a channel by its ID").setExample("broadcast \"%name of channel with id \"\"6515615645451561\"\"%");
    }
}

