/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.message;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Date;
import ch.njol.util.Kleenean;
import java.time.Instant;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.Util;
import net.dv8tion.jda.core.EmbedBuilder;
import net.dv8tion.jda.core.entities.Message;
import org.bukkit.event.Event;

public class ExprTimestamp
extends SimplePropertyExpression<Object, Date> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        return true;
    }

    public Date convert(Object object) {
        if (object instanceof EmbedBuilder) {
            EmbedBuilder embed = (EmbedBuilder)object;
            return embed.isEmpty() || embed.build().getTimestamp() == null ? null : Util.getDate(embed.build().getTimestamp());
        }
        if (object instanceof UpdatingMessage) {
            Message message = ((UpdatingMessage)object).getMessage();
            return Util.getDate(message.getCreationTime());
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) && this.getExpr().isSingle()) {
            return new Class[]{Date.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object input = this.getExpr().getSingle(e);
        if (!(input instanceof EmbedBuilder)) {
            return;
        }
        EmbedBuilder embed = (EmbedBuilder)input;
        if (embed == null) {
            return;
        }
        switch (mode) {
            case RESET: 
            case DELETE: {
                embed.setTimestamp(null);
                return;
            }
            case SET: {
                embed.setTimestamp(Instant.ofEpochMilli(((Date)delta[0]).getTimestamp()));
            }
        }
    }

    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    protected String getPropertyName() {
        return "timestamp of";
    }

    public String toString(Event e, boolean debug) {
        return "the timestamp of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprTimestamp.class, Date.class, "(timestamp|date)", "embedbuilders/messages").setName("Timestamp of").setDesc("Returns the timestamp of either a message or an embed. You can set the time of an embed to any date (e.g. now).").setExample("set the timestamp of {_embed} to now", "", "# You can also set it to a date in the past/future like this", "", "set {_thePast} to now", "subtract 5 days from {_thePast}", "set the timestamp of {_embed} to {_thePast}");
    }
}

