/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.message;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.List;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.skript.EasyMultiple;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.Role;
import org.bukkit.event.Event;

public class ExprMentionedRoles
extends SimpleExpression<Role>
implements EasyMultiple<UpdatingMessage, Role> {
    private Expression<UpdatingMessage> messages;

    protected Role[] get(Event e) {
        return (Role[])this.convert(this.getReturnType(), this.messages.getAll(e), msg -> {
            Message message = UpdatingMessage.convert(msg);
            List<Role> roles = message.getMentionedRoles();
            return roles.toArray(new Role[roles.size()]);
        });
    }

    public String toString(Event e, boolean debug) {
        return "mentioned roles of " + this.messages.toString(e, debug);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Role> getReturnType() {
        return Role.class;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.messages = exprs[0];
        return true;
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprMentionedRoles.class, Role.class, "mentioned role", "messages").setName("Mentioned Roles").setDesc("Get the mentioned Roles in a Message").setExample("set {_var::*} to event-message's mentioned roles");
    }
}

