/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.guild.role;

import ch.njol.skript.classes.Changer;
import java.awt.Color;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.changers.ChangeableSimplePropertyExpression;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.exceptions.PermissionException;
import org.bukkit.event.Event;

public class ExprRoleColor
extends ChangeableSimplePropertyExpression<Role, Color> {
    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode, boolean vixioChanger) {
        return new Class[]{Color.class};
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            for (Role role : (Role[])this.getExpr().getAll(e)) {
                Guild guild = Util.bindGuild(bot, role.getGuild());
                if (guild == null) continue;
                try {
                    guild.getRoleById(role.getId()).getManager().setColor((Color)delta[0]).queue();
                }
                catch (PermissionException x) {
                    Vixio.getErrorHandler().needsPerm(bot, "set the color of a role", x.getPermission().getName());
                }
            }
        }
    }

    protected String getPropertyName() {
        return "colo[u]r";
    }

    public Color convert(Role role) {
        return role.getColor();
    }

    public Class<? extends Color> getReturnType() {
        return Color.class;
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprRoleColor.class, Color.class, "colo[u]r", "roles").setName("Color of Role").setDesc("Get the color of a role. This can be set to any color.").setExample("set the color of {_role} to red with event-bot");
    }
}

