/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.guild.categories;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.List;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Guild;
import org.bukkit.event.Event;

public class ExprCategoryNamed
extends SimpleExpression<Category> {
    private Expression<Guild> guild;
    private Expression<String> category;

    protected Category[] get(Event e) {
        Category[] categoryArray;
        Guild guild = (Guild)this.guild.getSingle(e);
        String category = (String)this.category.getSingle(e);
        if (guild == null || category == null) {
            return null;
        }
        List<Category> categories = guild.getCategoriesByName(category, false);
        if (categories.size() > 1) {
            Vixio.getErrorHandler().warn("Vixio attempted to get a Category with the name " + category + " but more than one category exists with that name.");
            return null;
        }
        if (categories.isEmpty()) {
            categoryArray = null;
        } else {
            Category[] categoryArray2 = new Category[1];
            categoryArray = categoryArray2;
            categoryArray2[0] = categories.get(0);
        }
        return categoryArray;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Category> getReturnType() {
        return Category.class;
    }

    public String toString(Event e, boolean debug) {
        return "category named " + this.category.toString(e, debug) + " in " + this.guild.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.category = exprs[0];
        this.guild = exprs[1];
        return true;
    }

    static {
        Vixio.getInstance().registerExpression(ExprCategoryNamed.class, Category.class, ExpressionType.SIMPLE, "[the] category (with [the] name|named) %string% [in %guild%]").setName("Category named").setDesc("Get a Category by its name in a Guild.").setExample("discord command $create <text>:", "\ttrigger:", "\t\tcreate text channel:", "\t\t\tset the name of the channel to arg-1 ", "\t\t\tset the parent of the channel to category named \"xd\"", "\t\tcreate the last made channel in event-guild and store it in {_chnl}", "\t\treply with \"I've successfully created a channel named `%arg-1%`, ID: %id of {_chnl}%\"");
    }
}

