/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.vdurmont.emoji.EmojiParser;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.changers.ChangeableSimpleExpression;
import me.iblitzkriegi.vixio.changers.EffChange;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import me.iblitzkriegi.vixio.util.wrapper.Emote;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.exceptions.PermissionException;
import org.bukkit.event.Event;

public class ExprName
extends ChangeableSimpleExpression<String> {
    private Expression<Object> object;

    protected String[] get(Event e) {
        Object o = this.object.getSingle(e);
        if (o instanceof User) {
            return new String[]{((User)o).getName()};
        }
        if (o instanceof Guild) {
            return new String[]{((Guild)o).getName()};
        }
        if (o instanceof Channel) {
            return new String[]{((Channel)o).getName()};
        }
        if (o instanceof Bot) {
            return new String[]{((Bot)o).getName()};
        }
        if (o instanceof Role) {
            return new String[]{((Role)o).getName()};
        }
        if (o instanceof AudioTrack) {
            return new String[]{((AudioTrack)o).getInfo().title};
        }
        if (o instanceof Emote) {
            if (((Emote)o).isEmote()) {
                return new String[]{((Emote)o).getName()};
            }
            if (EmojiParser.parseToAliases(((Emote)o).getName()) != null) {
                return new String[]{EmojiParser.parseToAliases(((Emote)o).getName()).replaceAll(":", "")};
            }
            return null;
        }
        if (o instanceof MessageEmbed.Field) {
            return new String[]{((MessageEmbed.Field)o).getName()};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "discord name of " + this.object.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.object = exprs[0];
        return true;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode, boolean vixioChanger) {
        if (mode == Changer.ChangeMode.SET && this.object.isSingle()) {
            return new Class[]{String.class};
        }
        return null;
    }

    @Override
    public boolean shouldError() {
        return false;
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        Object object = this.object.getSingle(e);
        String name = (String)delta[0];
        switch (mode) {
            case SET: {
                if (object instanceof Bot) {
                    bot.getSelfUser().getManager().setName(name).queue();
                    break;
                }
                if (object instanceof Channel) {
                    Channel channel = Util.bindChannel(bot, (Channel)object);
                    try {
                        if (channel.getType() == ChannelType.TEXT) {
                            channel.getManager().setName(name.replaceAll(" ", "-")).queue();
                            break;
                        }
                        channel.getManager().setName(name).queue();
                    }
                    catch (PermissionException x) {
                        Vixio.getErrorHandler().needsPerm(bot, EffChange.format(mode, "name of", this.object, bot), x.getPermission().getName());
                    }
                    break;
                }
                if (!(object instanceof Guild)) break;
                Guild guild = Util.bindGuild(bot, (Guild)object);
                if (guild == null) {
                    return;
                }
                try {
                    guild.getManager().setName(name).queue();
                    break;
                }
                catch (PermissionException x) {
                    Vixio.getErrorHandler().needsPerm(bot, EffChange.format(mode, "name of", this.object, bot), x.getPermission().getName());
                }
            }
        }
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprName.class, String.class, "discord name", "channel/guild/bot/user/role/track/category/emote/field").setName("Name of").setDesc("Get the name of any discord entity. You can set the name of channels, guilds, bots, categories, and channel builders.").setExample("broadcast \"%name of event-user%\"");
    }
}

