/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.events;

import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import java.util.regex.MatchResult;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.events.base.BaseEvent;
import me.iblitzkriegi.vixio.events.base.SimpleVixioEvent;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.events.message.priv.PrivateMessageReceivedEvent;
import net.dv8tion.jda.core.exceptions.RateLimitedException;

public class EvtPrivateMessage
extends BaseEvent<PrivateMessageReceivedEvent> {
    private boolean sent;

    @Override
    public boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parser) {
        this.sent = ((MatchResult)parser.regexes.get(0)).group().equals("sent");
        return super.init(exprs, matchedPattern, parser);
    }

    @Override
    public boolean check(PrivateMessageReceivedEvent e) {
        if (this.sent && Util.botFromID(e.getAuthor().getId()) != null) {
            return super.check(e);
        }
        if (!this.sent && Util.botFromID(e.getAuthor().getId()) == null) {
            return super.check(e);
        }
        return false;
    }

    @Override
    public BaseEvent.Value[] getValues() {
        return new BaseEvent.Value[]{new BaseEvent.Value(MessageChannel.class, e -> {
            try {
                return e.getAuthor().openPrivateChannel().complete(true);
            }
            catch (RateLimitedException e1) {
                Vixio.getErrorHandler().warn("Vixio tried to get the message event value for the reaction add event but was rate limited");
                return null;
            }
            catch (UnsupportedOperationException x) {
                return null;
            }
        })};
    }

    static {
        BaseEvent.register("private message received", "<receive(d)?( seen)?|sent> [by %-string%]", EvtPrivateMessage.class, PrivateMessageEvent.class, "(private message|direct message)").setName("Private Message").setDesc("Fired when a private message is received or sent.").setExample("on direct message received:");
        EventValues.registerEventValue(PrivateMessageEvent.class, Bot.class, (Getter)new Getter<Bot, PrivateMessageEvent>(){

            public Bot get(PrivateMessageEvent event) {
                return Util.botFrom(((PrivateMessageReceivedEvent)event.getJDAEvent()).getJDA());
            }
        }, (int)0);
        EventValues.registerEventValue(PrivateMessageEvent.class, UpdatingMessage.class, (Getter)new Getter<UpdatingMessage, PrivateMessageEvent>(){

            public UpdatingMessage get(PrivateMessageEvent event) {
                return UpdatingMessage.from(((PrivateMessageReceivedEvent)event.getJDAEvent()).getMessage());
            }
        }, (int)0);
        EventValues.registerEventValue(PrivateMessageEvent.class, User.class, (Getter)new Getter<User, PrivateMessageEvent>(){

            public User get(PrivateMessageEvent event) {
                return ((PrivateMessageReceivedEvent)event.getJDAEvent()).getAuthor();
            }
        }, (int)0);
        EventValues.registerEventValue(PrivateMessageEvent.class, MessageChannel.class, (Getter)new Getter<MessageChannel, PrivateMessageEvent>(){

            public MessageChannel get(PrivateMessageEvent event) {
                return event.getValue(MessageChannel.class);
            }
        }, (int)0);
    }

    public class PrivateMessageEvent
    extends SimpleVixioEvent<PrivateMessageReceivedEvent> {
    }
}

