/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.events;

import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import me.iblitzkriegi.vixio.events.base.BaseEvent;
import me.iblitzkriegi.vixio.events.base.SimpleVixioEvent;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.events.message.guild.GuildMessageReceivedEvent;

public class EvtGuildMessageReceive
extends BaseEvent<GuildMessageReceivedEvent> {
    private boolean sent;

    @Override
    public boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parser) {
        this.sent = parser.mark == 2;
        return super.init(exprs, matchedPattern, parser);
    }

    @Override
    public boolean check(GuildMessageReceivedEvent e) {
        if (this.sent && Util.botFromID(e.getAuthor().getId()) != null) {
            return super.check(e);
        }
        if (!this.sent && Util.botFromID(e.getAuthor().getId()) == null) {
            return super.check(e);
        }
        return false;
    }

    static {
        BaseEvent.register("guild message received", "(1\u00a6receive[d] [seen]|2\u00a6 sent) [by %-string%]", EvtGuildMessageReceive.class, GuildMessageReceiveEvent.class, "(guild|server) message").setName("Guild Message Received").setDesc("Fired when a message is sent in a text channel that the bot can read.").setUserFacing("(guild|server) message (receive[d] [seen]| sent) [by %-string%]").setExample("on guild message received seen by \"a bot\":");
        EventValues.registerEventValue(GuildMessageReceiveEvent.class, Channel.class, (Getter)new Getter<Channel, GuildMessageReceiveEvent>(){

            public Channel get(GuildMessageReceiveEvent event) {
                return ((GuildMessageReceivedEvent)event.getJDAEvent()).getChannel();
            }
        }, (int)0);
        EventValues.registerEventValue(GuildMessageReceiveEvent.class, MessageChannel.class, (Getter)new Getter<MessageChannel, GuildMessageReceiveEvent>(){

            public MessageChannel get(GuildMessageReceiveEvent event) {
                return ((GuildMessageReceivedEvent)event.getJDAEvent()).getChannel();
            }
        }, (int)0);
        EventValues.registerEventValue(GuildMessageReceiveEvent.class, User.class, (Getter)new Getter<User, GuildMessageReceiveEvent>(){

            public User get(GuildMessageReceiveEvent event) {
                return ((GuildMessageReceivedEvent)event.getJDAEvent()).getAuthor();
            }
        }, (int)0);
        EventValues.registerEventValue(GuildMessageReceiveEvent.class, Member.class, (Getter)new Getter<Member, GuildMessageReceiveEvent>(){

            public Member get(GuildMessageReceiveEvent event) {
                return ((GuildMessageReceivedEvent)event.getJDAEvent()).getMember();
            }
        }, (int)0);
        EventValues.registerEventValue(GuildMessageReceiveEvent.class, UpdatingMessage.class, (Getter)new Getter<UpdatingMessage, GuildMessageReceiveEvent>(){

            public UpdatingMessage get(GuildMessageReceiveEvent event) {
                return UpdatingMessage.from(((GuildMessageReceivedEvent)event.getJDAEvent()).getMessage());
            }
        }, (int)0);
        EventValues.registerEventValue(GuildMessageReceiveEvent.class, Guild.class, (Getter)new Getter<Guild, GuildMessageReceiveEvent>(){

            public Guild get(GuildMessageReceiveEvent event) {
                return ((GuildMessageReceivedEvent)event.getJDAEvent()).getGuild();
            }
        }, (int)0);
        EventValues.registerEventValue(GuildMessageReceiveEvent.class, Bot.class, (Getter)new Getter<Bot, GuildMessageReceiveEvent>(){

            public Bot get(GuildMessageReceiveEvent event) {
                return Util.botFrom(((GuildMessageReceivedEvent)event.getJDAEvent()).getJDA());
            }
        }, (int)0);
        EventValues.registerEventValue(GuildMessageReceiveEvent.class, String.class, (Getter)new Getter<String, GuildMessageReceiveEvent>(){

            public String get(GuildMessageReceiveEvent event) {
                return ((GuildMessageReceivedEvent)event.getJDAEvent()).getMessage().getContentRaw();
            }
        }, (int)0);
    }

    public class GuildMessageReceiveEvent
    extends SimpleVixioEvent<GuildMessageReceivedEvent> {
    }
}

