/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.guild;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.exceptions.PermissionException;
import org.bukkit.event.Event;

public class EffPermissionOverride
extends Effect {
    private Expression<Channel> channel;
    private Expression<Object> bot;
    private Expression<Permission> permissions;
    private Expression<Object> inputs;
    private boolean allow;

    protected void execute(Event e) {
        Channel[] channels;
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        if (bot == null) {
            return;
        }
        Permission[] permissions = (Permission[])this.permissions.getAll(e);
        Object[] inputs = this.inputs.getAll(e);
        for (Channel channel : channels = (Channel[])this.channel.getAll(e)) {
            for (Object input : inputs) {
                try {
                    if (input instanceof Role) {
                        Role role = (Role)input;
                        if (this.allow) {
                            channel.putPermissionOverride(role).setAllow(permissions).queue();
                            continue;
                        }
                        channel.putPermissionOverride(role).setDeny(permissions).queue();
                        continue;
                    }
                    if (!(input instanceof Member)) continue;
                    Member member = (Member)input;
                    if (this.allow) {
                        channel.putPermissionOverride(member).setAllow(permissions).queue();
                        continue;
                    }
                    channel.putPermissionOverride(member).setDeny(permissions).queue();
                }
                catch (PermissionException x) {
                    Vixio.getErrorHandler().needsPerm(bot, "manage permissions", x.getPermission().getName());
                }
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return (this.allow ? "allow " : "deny ") + this.inputs.toString(e, debug) + " the permission " + this.permissions.toString(e, debug) + (this.channel == null ? "" : " in " + this.channel.toString(e, debug)) + " with " + this.bot.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.inputs = exprs[0];
        this.permissions = exprs[1];
        this.channel = exprs[2];
        this.bot = exprs[3];
        this.allow = parseResult.mark == 0;
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffPermissionOverride.class, "(allow|1\u00a6deny) %roles/members% [the] permission[s] %permissions% [in %channels%] [with %bot/string%]").setName("Member Permission in Channel").setDesc("Allow, or deny a role or a member permissions to a channel").setExample("discord command grant <text> <permission>:", "\ttrigger:", "\t\tif id of event-guild is not \"219967335266648065\":", "\t\t\tstop", "\t\tset {_role} to role with id arg-1", "\t\tallow {_role} the permission arg-2 in event-channel", "\t\tdeny the public role of event-guild the permission arg-2 in event-channel");
    }
}

