/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.channel;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.exceptions.PermissionException;
import org.bukkit.event.Event;

public class EffSendTyping
extends Effect {
    private Expression<Object> location;
    private Expression<Object> bot;

    protected void execute(Event e) {
        TextChannel bindedChannel;
        Object location = this.location.getSingle(e);
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        if (bot == null || location == null) {
            return;
        }
        if (location instanceof User) {
            User user = Util.bindUser(bot, (User)location);
            if (user != null) {
                user.openPrivateChannel().queue(privateChannel -> privateChannel.sendTyping().queue());
            }
        } else if (location instanceof TextChannel && (bindedChannel = Util.bindChannel(bot, (TextChannel)location)) != null) {
            try {
                bindedChannel.sendTyping().queue();
            }
            catch (PermissionException x) {
                Vixio.getErrorHandler().needsPerm(bot, "send typing", x.getPermission().getName());
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "send typing in " + this.location.toString(e, debug) + " with " + this.bot.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.location = exprs[0];
        this.bot = exprs[1];
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffSendTyping.class, "send typing (to|in) %channel/user% [with %bot/string%]").setName("Send typing").setDesc("Make a bot start typing in a text channel.").setUserFacing("send typing in %textchannel/user% [with %bot/string%]").setExample("send typing in event-channel");
    }
}

