/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.channel;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.exceptions.PermissionException;
import org.bukkit.event.Event;

public class EffPinMessage
extends Effect {
    private Expression<UpdatingMessage> message;
    private Expression<Object> bot;

    protected void execute(Event e) {
        UpdatingMessage updatingMessage = (UpdatingMessage)this.message.getSingle(e);
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        if (updatingMessage == null || bot == null) {
            return;
        }
        Message message = updatingMessage.getMessage();
        MessageChannel channel = Util.bindMessageChannel(bot, message.getChannel());
        if (channel == null) {
            return;
        }
        try {
            channel.pinMessageById(message.getId()).queue();
        }
        catch (PermissionException x) {
            Vixio.getErrorHandler().needsPerm(bot, "pin message", x.getPermission().getName());
        }
    }

    public String toString(Event e, boolean debug) {
        return "pin " + this.message.toString(e, debug) + " with " + this.bot.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.message = exprs[0];
        this.bot = exprs[1];
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffPinMessage.class, "pin %messages% [with %bot/string%]").setName("Pin Message").setDesc("Pin a message in a channel.").setExample("pin event-message in event-channel");
    }
}

