/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.User;
import org.bukkit.event.Event;

public class CondHasPermission
extends Condition {
    private Expression<User> user;
    private Expression<Member> member;
    private Expression<Permission> permission;
    private Expression<Object> object;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 1 || matchedPattern == 3) {
            this.user = exprs[0];
        } else {
            this.member = exprs[0];
        }
        this.permission = exprs[1];
        this.object = exprs[2];
        this.setNegated(matchedPattern > 1);
        return true;
    }

    public boolean check(Event e) {
        Member member = this.member == null ? null : (Member)this.member.getSingle(e);
        User user = this.user == null ? null : (User)this.user.getSingle(e);
        Object object = this.object == null ? null : this.object.getSingle(e);
        Permission permission = (Permission)((Object)this.permission.getSingle(e));
        if (permission == null) {
            return false;
        }
        if (member != null) {
            if (object == null) {
                return this.isNegated() != member.hasPermission(permission);
            }
            if (object instanceof Channel) {
                return this.isNegated() != member.hasPermission((Channel)object, permission);
            }
            return false;
        }
        if (user != null && object != null) {
            Guild guild = null;
            if (object instanceof Guild) {
                guild = (Guild)object;
            } else if (object instanceof Channel) {
                guild = ((Channel)object).getGuild();
            }
            if (guild == null) {
                return false;
            }
            Member guildMember = guild.getMember(user);
            if (guildMember == null) {
                return false;
            }
            if (object instanceof Channel) {
                return this.isNegated() != member.hasPermission((Channel)object, permission);
            }
            if (object instanceof Guild) {
                return this.isNegated() != member.hasPermission(permission);
            }
            return false;
        }
        return false;
    }

    public String toString(Event e, boolean debug) {
        return this.member == null ? this.user.toString(e, debug) : this.member.toString(e, debug) + " has permission " + this.permission.toString(e, debug) + (this.object == null ? "" : " in " + this.object.toString(e, debug));
    }

    static {
        Vixio.getInstance().registerCondition(CondHasPermission.class, "%member% has permission %permission% [in %-channel%]", "%user% has permission %permission% [in %guild/channel%]", "%member% (doesn[']t|does not) have permission %permission% [in %-channel%]", "%user% (doesn[']t|does not) have permission %permission% [in %guild/channel%]").setName("Member Has Permission").setDesc("Check if a member has a permission, can also check if they have a permission in a certain channel.").setExample("if event-member has permission voice connect");
    }
}

