/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.commands;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.MatchResult;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.commands.DiscordCommand;
import me.iblitzkriegi.vixio.commands.DiscordCommandEvent;
import me.iblitzkriegi.vixio.commands.DiscordCommandFactory;
import me.iblitzkriegi.vixio.util.UpdatingMessage;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.User;
import org.bukkit.event.Event;

public class DiscordCommandRegistry
extends SelfRegisteringSkriptEvent {
    private String arguments;
    private String command;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.command = ((MatchResult)parser.regexes.get(0)).group(1);
        this.arguments = ((MatchResult)parser.regexes.get(0)).group(2);
        SectionNode sectionNode = (SectionNode)SkriptLogger.getNode();
        String originalName = ScriptLoader.getCurrentEventName();
        Class[] originalEvents = ScriptLoader.getCurrentEvents();
        Kleenean originalDelay = ScriptLoader.hasDelayBefore;
        ScriptLoader.setCurrentEvent((String)"discord command", (Class[])new Class[]{DiscordCommandEvent.class});
        DiscordCommand cmd = DiscordCommandFactory.getInstance().add(sectionNode);
        this.command = cmd == null ? this.command : cmd.getName();
        ScriptLoader.setCurrentEvent((String)originalName, (Class[])originalEvents);
        ScriptLoader.hasDelayBefore = originalDelay;
        this.nukeSectionNode(sectionNode);
        return cmd != null;
    }

    public void afterParse(Config config) {
    }

    public void register(Trigger t) {
    }

    public void unregister(Trigger t) {
        DiscordCommandFactory.getInstance().remove(this.command);
    }

    public void unregisterAll() {
        DiscordCommandFactory.getInstance().commandMap.clear();
    }

    public String toString(Event e, boolean debug) {
        return "discord command " + this.command + (this.arguments == null ? "" : this.arguments);
    }

    public void nukeSectionNode(SectionNode sectionNode) {
        ArrayList nodes = new ArrayList();
        Iterator iterator = sectionNode.iterator();
        while (iterator.hasNext()) {
            nodes.add(iterator.next());
        }
        for (Node n : nodes) {
            sectionNode.remove(n);
        }
    }

    static {
        Vixio.getInstance().registerEvent("Discord Command", DiscordCommandRegistry.class, DiscordCommandEvent.class, "discord command <([^\\s]+)( .+)?$>").setName("Discord Command").setDesc("Vixio's custom Discord command system").setExample("discord command cmd <member>:", "\tprefixes: \"hey \", \"%mention tag of event-bot% \", ##", "\taliases: info, user", "\troles: Dev", "\tdescription: Get some information about a user", "\tusage: hey info <member>", "\tbots: {@bot}", "\texecutable in: guild", "\ttrigger:", "\t\tset {_} to a message builder", "\t\tappend line \"-=Who is %name of arg-1%=-\"", "\t\tappend line \"Name: %name of arg-1%\"", "\t\tappend line \"ID: %id of arg-1%\"", "\t\tappend line \"Mention tag: %mention tag of arg-1%\"", "\t\tappend line \"Status: %online status of arg-1%\"", "\t\treply with {_}");
        EventValues.registerEventValue(DiscordCommandEvent.class, DiscordCommand.class, (Getter)new Getter<DiscordCommand, DiscordCommandEvent>(){

            public DiscordCommand get(DiscordCommandEvent event) {
                return event.getCommand();
            }
        }, (int)0);
        EventValues.registerEventValue(DiscordCommandEvent.class, User.class, (Getter)new Getter<User, DiscordCommandEvent>(){

            public User get(DiscordCommandEvent event) {
                return event.getUser();
            }
        }, (int)0);
        EventValues.registerEventValue(DiscordCommandEvent.class, Member.class, (Getter)new Getter<Member, DiscordCommandEvent>(){

            public Member get(DiscordCommandEvent event) {
                return event.getMember();
            }
        }, (int)0);
        EventValues.registerEventValue(DiscordCommandEvent.class, Channel.class, (Getter)new Getter<Channel, DiscordCommandEvent>(){

            public Channel get(DiscordCommandEvent event) {
                return event.getChannel();
            }
        }, (int)0);
        EventValues.registerEventValue(DiscordCommandEvent.class, MessageChannel.class, (Getter)new Getter<MessageChannel, DiscordCommandEvent>(){

            public MessageChannel get(DiscordCommandEvent event) {
                return event.getMessageChannel();
            }
        }, (int)0);
        EventValues.registerEventValue(DiscordCommandEvent.class, UpdatingMessage.class, (Getter)new Getter<UpdatingMessage, DiscordCommandEvent>(){

            public UpdatingMessage get(DiscordCommandEvent event) {
                return UpdatingMessage.from(event.getMessage());
            }
        }, (int)0);
        EventValues.registerEventValue(DiscordCommandEvent.class, Guild.class, (Getter)new Getter<Guild, DiscordCommandEvent>(){

            public Guild get(DiscordCommandEvent event) {
                return event.getGuild();
            }
        }, (int)0);
        EventValues.registerEventValue(DiscordCommandEvent.class, Bot.class, (Getter)new Getter<Bot, DiscordCommandEvent>(){

            public Bot get(DiscordCommandEvent event) {
                return event.getBot();
            }
        }, (int)0);
    }
}

