/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeFormatInfo;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeMpegStreamAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import me.iblitzkriegi.vixio.org.apache.http.client.utils.URLEncodedUtils;
import me.iblitzkriegi.vixio.org.apache.http.entity.ContentType;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioTrack.class);
    private static final String DEFAULT_SIGNATURE_KEY = "signature";
    private final YoutubeAudioSourceManager sourceManager;

    public YoutubeAudioTrack(AudioTrackInfo trackInfo, YoutubeAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            FormatWithUrl format = this.loadBestFormatWithUrl(httpInterface);
            log.debug("Starting track from URL: {}", (Object)format.signedUrl);
            if (this.trackInfo.isStream) {
                this.processStream(localExecutor, format);
            } else {
                this.processStatic(localExecutor, httpInterface, format);
            }
        }
    }

    private void processStatic(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface, FormatWithUrl format) throws Exception {
        try (YoutubePersistentHttpStream stream = new YoutubePersistentHttpStream(httpInterface, format.signedUrl, format.details.getContentLength());){
            if (format.details.getType().getMimeType().endsWith("/webm")) {
                this.processDelegate(new MatroskaAudioTrack(this.trackInfo, stream), localExecutor);
            } else {
                this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
            }
        }
    }

    private void processStream(LocalAudioTrackExecutor localExecutor, FormatWithUrl format) throws Exception {
        if ("audio/webm".equals(format.details.getType().getMimeType())) {
            throw new FriendlyException("YouTube WebM streams are currently not supported.", FriendlyException.Severity.COMMON, null);
        }
        try (HttpInterface streamingInterface = this.sourceManager.getHttpInterface();){
            this.processDelegate(new YoutubeMpegStreamAudioTrack(this.trackInfo, streamingInterface, format.signedUrl), localExecutor);
        }
    }

    private FormatWithUrl loadBestFormatWithUrl(HttpInterface httpInterface) throws Exception {
        JsonBrowser info = this.getTrackInfo(httpInterface);
        String playerScript = YoutubeAudioTrack.extractPlayerScriptFromInfo(info);
        List<YoutubeTrackFormat> formats = this.loadTrackFormats(info, httpInterface, playerScript);
        YoutubeTrackFormat format = YoutubeAudioTrack.findBestSupportedFormat(formats);
        URI signedUrl = this.sourceManager.getCipherManager().getValidUrl(httpInterface, playerScript, format);
        return new FormatWithUrl(format, signedUrl);
    }

    @Override
    public AudioTrack makeClone() {
        return new YoutubeAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    private JsonBrowser getTrackInfo(HttpInterface httpInterface) throws Exception {
        return this.sourceManager.getTrackInfoFromMainPage(httpInterface, this.getIdentifier(), true);
    }

    private List<YoutubeTrackFormat> loadTrackFormats(JsonBrowser info, HttpInterface httpInterface, String playerScript) throws Exception {
        JsonBrowser args = info.safeGet("args");
        String adaptiveFormats = args.safeGet("adaptive_fmts").text();
        if (adaptiveFormats != null) {
            return this.loadTrackFormatsFromAdaptive(adaptiveFormats);
        }
        String dashUrl = args.safeGet("dashmpd").text();
        if (dashUrl != null) {
            return this.loadTrackFormatsFromDash(dashUrl, httpInterface, playerScript);
        }
        String formatStreamMap = args.safeGet("url_encoded_fmt_stream_map").text();
        if (formatStreamMap != null) {
            return this.loadTrackFormatsFromFormatStreamMap(formatStreamMap);
        }
        throw new FriendlyException("Unable to play this YouTube track.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("No adaptive formats, no dash, no stream map."));
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromAdaptive(String adaptiveFormats) throws Exception {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        for (String formatString : adaptiveFormats.split(",")) {
            Map<String, String> format = DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(formatString, Charset.forName("UTF-8")));
            tracks.add(new YoutubeTrackFormat(ContentType.parse(format.get("type")), Long.parseLong(format.get("bitrate")), Long.parseLong(format.get("clen")), format.get("url"), format.get("s"), format.getOrDefault("sp", DEFAULT_SIGNATURE_KEY)));
        }
        return tracks;
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromFormatStreamMap(String adaptiveFormats) throws Exception {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        for (String formatString : adaptiveFormats.split(",")) {
            Map<String, String> format = DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(formatString, Charset.forName("UTF-8")));
            String url = format.get("url");
            String contentLength = DataFormatTools.extractBetween(url, "clen=", "&");
            if (contentLength == null) {
                log.debug("Could not find content length from URL {}, skipping format", (Object)url);
                continue;
            }
            tracks.add(new YoutubeTrackFormat(ContentType.parse(format.get("type")), this.qualityToBitrateValue(format.get("quality")), Long.parseLong(contentLength), url, format.get("s"), format.getOrDefault("sp", DEFAULT_SIGNATURE_KEY)));
        }
        return tracks;
    }

    private long qualityToBitrateValue(String quality) {
        if ("small".equals(quality)) {
            return -10L;
        }
        if ("medium".equals(quality)) {
            return -5L;
        }
        if ("hd720".equals(quality)) {
            return -4L;
        }
        return -1L;
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromDash(String dashUrl, HttpInterface httpInterface, String playerScript) throws Exception {
        String resolvedDashUrl = this.sourceManager.getCipherManager().getValidDashUrl(httpInterface, playerScript, dashUrl);
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(resolvedDashUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code for track info page response: " + statusCode);
            }
            Document document = Jsoup.parse(response.getEntity().getContent(), "UTF-8", "", Parser.xmlParser());
            List<YoutubeTrackFormat> list = this.loadTrackFormatsFromDashDocument(document);
            return list;
        }
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromDashDocument(Document document) {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        for (Element adaptation : document.select("AdaptationSet")) {
            String mimeType = adaptation.attr("mimeType");
            for (Element representation : adaptation.select("Representation")) {
                String url = representation.select("BaseURL").first().text();
                String contentLength = DataFormatTools.extractBetween(url, "/clen/", "/");
                String contentType = mimeType + "; codecs=" + representation.attr("codecs");
                if (contentLength == null) {
                    log.debug("Skipping format {} because the content length is missing", (Object)contentType);
                    continue;
                }
                tracks.add(new YoutubeTrackFormat(ContentType.parse(contentType), Long.parseLong(representation.attr("bandwidth")), Long.parseLong(contentLength), url, null, DEFAULT_SIGNATURE_KEY));
            }
        }
        return tracks;
    }

    private static String extractPlayerScriptFromInfo(JsonBrowser info) {
        return info.get("assets").get("js").text();
    }

    private static boolean isBetterFormat(YoutubeTrackFormat format, YoutubeTrackFormat other) {
        YoutubeFormatInfo info = format.getInfo();
        if (info == null) {
            return false;
        }
        if (other == null) {
            return true;
        }
        if (info.ordinal() != other.getInfo().ordinal()) {
            return info.ordinal() < other.getInfo().ordinal();
        }
        return format.getBitrate() > other.getBitrate();
    }

    private static YoutubeTrackFormat findBestSupportedFormat(List<YoutubeTrackFormat> formats) throws Exception {
        YoutubeTrackFormat bestFormat = null;
        for (YoutubeTrackFormat format2 : formats) {
            if (!YoutubeAudioTrack.isBetterFormat(format2, bestFormat)) continue;
            bestFormat = format2;
        }
        if (bestFormat == null) {
            StringJoiner joiner = new StringJoiner(", ");
            formats.forEach(format -> joiner.add(format.getType().toString()));
            throw new IllegalStateException("No supported audio streams available, available types: " + joiner.toString());
        }
        return bestFormat;
    }

    private static class FormatWithUrl {
        private final YoutubeTrackFormat details;
        private final URI signedUrl;

        private FormatWithUrl(YoutubeTrackFormat details, URI signedUrl) {
            this.details = details;
            this.signedUrl = signedUrl;
        }
    }
}

