/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.stream;

import com.sedmelluq.discord.lavaplayer.container.adts.AdtsAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpegts.MpegTsElementaryInputStream;
import com.sedmelluq.discord.lavaplayer.container.mpegts.PesPacketInputStream;
import com.sedmelluq.discord.lavaplayer.source.stream.M3uStreamSegmentUrlProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.ChainedInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;

public abstract class M3uStreamAudioTrack
extends DelegatedAudioTrack {
    public M3uStreamAudioTrack(AudioTrackInfo trackInfo) {
        super(trackInfo);
    }

    protected abstract M3uStreamSegmentUrlProvider getSegmentUrlProvider();

    protected abstract HttpInterface getHttpInterface();

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.getHttpInterface();
             ChainedInputStream chainedInputStream = new ChainedInputStream(() -> this.getSegmentUrlProvider().getNextSegmentStream(httpInterface));){
            MpegTsElementaryInputStream elementaryInputStream = new MpegTsElementaryInputStream(chainedInputStream, 15);
            PesPacketInputStream pesPacketInputStream = new PesPacketInputStream(elementaryInputStream);
            this.processDelegate(new AdtsAudioTrack(this.trackInfo, pesPacketInputStream), localExecutor);
        }
    }
}

