/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.http;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDescriptor;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(HttpAudioTrack.class);
    private final MediaContainerDescriptor containerTrackFactory;
    private final HttpAudioSourceManager sourceManager;

    public HttpAudioTrack(AudioTrackInfo trackInfo, MediaContainerDescriptor containerTrackFactory, HttpAudioSourceManager sourceManager) {
        super(trackInfo);
        this.containerTrackFactory = containerTrackFactory;
        this.sourceManager = sourceManager;
    }

    public MediaContainerDescriptor getContainerTrackFactory() {
        return this.containerTrackFactory;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            log.debug("Starting http track from URL: {}", (Object)this.trackInfo.identifier);
            try (PersistentHttpStream inputStream = new PersistentHttpStream(httpInterface, new URI(this.trackInfo.identifier), Long.MAX_VALUE);){
                this.processDelegate((InternalAudioTrack)this.containerTrackFactory.createTrack(this.trackInfo, inputStream), localExecutor);
            }
        }
    }

    @Override
    public AudioTrack makeClone() {
        return new HttpAudioTrack(this.trackInfo, this.containerTrackFactory, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

