/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.playlists;

import com.sedmelluq.discord.lavaplayer.source.stream.ExtendedM3uParser;
import com.sedmelluq.discord.lavaplayer.source.stream.M3uStreamSegmentUrlProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.util.List;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HlsStreamSegmentUrlProvider
extends M3uStreamSegmentUrlProvider {
    private static final Logger log = LoggerFactory.getLogger(HlsStreamSegmentUrlProvider.class);
    private final String streamListUrl;
    private volatile String segmentPlaylistUrl;

    public HlsStreamSegmentUrlProvider(String streamListUrl, String segmentPlaylistUrl) {
        this.streamListUrl = streamListUrl;
        this.segmentPlaylistUrl = segmentPlaylistUrl;
    }

    @Override
    protected String getQualityFromM3uDirective(ExtendedM3uParser.Line directiveLine) {
        return "default";
    }

    @Override
    protected String fetchSegmentPlaylistUrl(HttpInterface httpInterface) throws IOException {
        if (this.segmentPlaylistUrl != null) {
            return this.segmentPlaylistUrl;
        }
        HttpGet request = new HttpGet(this.streamListUrl);
        List<M3uStreamSegmentUrlProvider.ChannelStreamInfo> streams = this.loadChannelStreamsList(HttpClientTools.fetchResponseLines(httpInterface, request, "HLS stream list"));
        if (streams.isEmpty()) {
            throw new IllegalStateException("No streams listed in HLS stream list.");
        }
        M3uStreamSegmentUrlProvider.ChannelStreamInfo stream = streams.get(0);
        log.debug("Chose stream with url {}", (Object)stream.quality, (Object)stream.url);
        this.segmentPlaylistUrl = stream.url;
        return this.segmentPlaylistUrl;
    }

    @Override
    protected HttpUriRequest createSegmentGetRequest(String url) {
        return new HttpGet(url);
    }

    public static String findHlsEntryUrl(String[] lines) {
        List<M3uStreamSegmentUrlProvider.ChannelStreamInfo> streams = new HlsStreamSegmentUrlProvider(null, null).loadChannelStreamsList(lines);
        return streams.isEmpty() ? null : streams.get((int)0).url;
    }
}

