/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg.vorbis;

import com.sedmelluq.discord.lavaplayer.container.ogg.OggCodecHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggMetadata;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.vorbis.OggVorbisTrackHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.vorbis.VorbisCommentParser;
import com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class OggVorbisCodecHandler
implements OggCodecHandler {
    private static final int VORBIS_IDENTIFIER = ByteBuffer.wrap(new byte[]{1, 118, 111, 114}).getInt();
    private static final int MAX_COMMENTS_SAVED_LENGTH = 131072;
    private static final int MAX_COMMENTS_READ_LENGTH = 0x7800000;
    private static final byte[] COMMENT_PACKET_START = new byte[]{3, 118, 111, 114, 98, 105, 115};

    @Override
    public boolean isMatchingIdentifier(int identifier) {
        return identifier == VORBIS_IDENTIFIER;
    }

    @Override
    public int getMaximumFirstPacketLength() {
        return 64;
    }

    @Override
    public OggTrackHandler loadTrackHandler(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        byte[] infoPacket = broker.extractBytes();
        this.loadCommentsHeader(stream, broker, true);
        return new OggVorbisTrackHandler(infoPacket, stream, broker);
    }

    @Override
    public OggMetadata loadMetadata(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        this.loadCommentsHeader(stream, broker, false);
        ByteBuffer commentsPacket = broker.getBuffer();
        byte[] packetStart = new byte[COMMENT_PACKET_START.length];
        commentsPacket.get(packetStart);
        if (!Arrays.equals(packetStart, COMMENT_PACKET_START)) {
            return OggMetadata.EMPTY;
        }
        return new OggMetadata(VorbisCommentParser.parse(commentsPacket, broker.isTruncated()), null);
    }

    private void loadCommentsHeader(OggPacketInputStream stream, DirectBufferStreamBroker broker, boolean skip) throws IOException {
        if (!stream.startNewPacket()) {
            throw new IllegalStateException("No comments packet in track.");
        }
        if (!broker.consumeNext(stream, skip ? 0 : 131072, 0x7800000) && !stream.isPacketComplete()) {
            throw new IllegalStateException("Vorbis comments header packet longer than allowed.");
        }
    }
}

