/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg.opus;

import com.sedmelluq.discord.lavaplayer.container.ogg.OggCodecHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggMetadata;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggStreamSizeInfo;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.opus.OggOpusTrackHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.vorbis.VorbisCommentParser;
import com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;

public class OggOpusCodecHandler
implements OggCodecHandler {
    private static final int OPUS_IDENTIFIER = ByteBuffer.wrap(new byte[]{79, 112, 117, 115}).getInt();
    private static final int HEAD_TAG_HALF = ByteBuffer.wrap(new byte[]{72, 101, 97, 100}).getInt();
    private static final int OPUS_TAG_HALF = ByteBuffer.wrap(new byte[]{79, 112, 117, 115}).getInt();
    private static final int TAGS_TAG_HALF = ByteBuffer.wrap(new byte[]{84, 97, 103, 115}).getInt();
    private static final int MAX_COMMENTS_SAVED_LENGTH = 61440;
    private static final int MAX_COMMENTS_READ_LENGTH = 0x7800000;

    @Override
    public boolean isMatchingIdentifier(int identifier) {
        return identifier == OPUS_IDENTIFIER;
    }

    @Override
    public int getMaximumFirstPacketLength() {
        return 276;
    }

    @Override
    public OggTrackHandler loadTrackHandler(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        ByteBuffer firstPacket = broker.getBuffer();
        this.verifyFirstPacket(firstPacket);
        this.loadCommentsHeader(stream, broker, true);
        int channelCount = firstPacket.get(9) & 0xFF;
        return new OggOpusTrackHandler(stream, broker, channelCount, this.getSampleRate(firstPacket));
    }

    @Override
    public OggMetadata loadMetadata(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        ByteBuffer firstPacket = broker.getBuffer();
        this.verifyFirstPacket(firstPacket);
        this.loadCommentsHeader(stream, broker, false);
        return new OggMetadata(this.parseTags(broker.getBuffer(), broker.isTruncated()), this.detectLength(stream, this.getSampleRate(firstPacket)));
    }

    private Map<String, String> parseTags(ByteBuffer tagBuffer, boolean truncated) {
        if (tagBuffer.getInt() != OPUS_TAG_HALF || tagBuffer.getInt() != TAGS_TAG_HALF) {
            return Collections.emptyMap();
        }
        return VorbisCommentParser.parse(tagBuffer, truncated);
    }

    private Long detectLength(OggPacketInputStream stream, int sampleRate) throws IOException {
        OggStreamSizeInfo sizeInfo = stream.seekForSizeInfo(sampleRate);
        if (sizeInfo != null) {
            return sizeInfo.totalSamples * 1000L / (long)sizeInfo.sampleRate;
        }
        return null;
    }

    private void verifyFirstPacket(ByteBuffer firstPacket) {
        if (firstPacket.getInt(4) != HEAD_TAG_HALF) {
            throw new IllegalStateException("First packet is not an OpusHead.");
        }
    }

    private int getSampleRate(ByteBuffer firstPacket) {
        return Integer.reverseBytes(firstPacket.getInt(12));
    }

    private void loadCommentsHeader(OggPacketInputStream stream, DirectBufferStreamBroker broker, boolean skip) throws IOException {
        if (!stream.startNewPacket()) {
            throw new IllegalStateException("No OpusTags packet in track.");
        }
        if (!broker.consumeNext(stream, skip ? 0 : 61440, 0x7800000) && !stream.isPacketComplete()) {
            throw new IllegalStateException("Opus comments header packet longer than allowed.");
        }
    }
}

