/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg.flac;

import com.sedmelluq.discord.lavaplayer.container.flac.FlacMetadataReader;
import com.sedmelluq.discord.lavaplayer.container.flac.FlacStreamInfo;
import com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfo;
import com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfoBuilder;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggCodecHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggMetadata;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggStreamSizeInfo;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.flac.OggFlacTrackHandler;
import com.sedmelluq.discord.lavaplayer.tools.io.ByteBufferInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OggFlacCodecHandler
implements OggCodecHandler {
    private static final int FLAC_IDENTIFIER = ByteBuffer.wrap(new byte[]{127, 70, 76, 65}).getInt();
    private static final int NATIVE_FLAC_HEADER_OFFSET = 9;
    private static final int NATIVE_FLAC_HEADER = ByteBuffer.wrap(new byte[]{102, 76, 97, 67}).getInt();

    @Override
    public boolean isMatchingIdentifier(int identifier) {
        return identifier == FLAC_IDENTIFIER;
    }

    @Override
    public int getMaximumFirstPacketLength() {
        return 51;
    }

    @Override
    public OggTrackHandler loadTrackHandler(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        return new OggFlacTrackHandler(this.load(stream, broker), stream);
    }

    @Override
    public OggMetadata loadMetadata(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        FlacTrackInfo info = this.load(stream, broker);
        return new OggMetadata(info.tags, this.detectLength(info, stream));
    }

    private FlacTrackInfo load(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        ByteBuffer buffer = broker.getBuffer();
        if (buffer.getInt(9) != NATIVE_FLAC_HEADER) {
            throw new IllegalStateException("Native flac header not found.");
        }
        buffer.position(13);
        return this.readHeaders(buffer, stream);
    }

    private Long detectLength(FlacTrackInfo info, OggPacketInputStream stream) throws IOException {
        OggStreamSizeInfo sizeInfo = info.stream.sampleCount > 0L ? new OggStreamSizeInfo(0L, info.stream.sampleCount, 0L, 0L, info.stream.sampleRate) : stream.seekForSizeInfo(info.stream.sampleRate);
        return sizeInfo != null ? Long.valueOf(sizeInfo.getDuration()) : null;
    }

    private FlacTrackInfo readHeaders(ByteBuffer firstPacketBuffer, OggPacketInputStream packetInputStream) throws IOException {
        FlacStreamInfo streamInfo = FlacMetadataReader.readStreamInfoBlock(new DataInputStream(new ByteBufferInputStream(firstPacketBuffer)));
        FlacTrackInfoBuilder trackInfoBuilder = new FlacTrackInfoBuilder(streamInfo);
        DataInputStream dataInputStream = new DataInputStream(packetInputStream);
        boolean hasMoreMetadata = trackInfoBuilder.getStreamInfo().hasMetadataBlocks;
        while (hasMoreMetadata) {
            if (!packetInputStream.startNewPacket()) {
                throw new IllegalStateException("Track ended when more metadata was expected.");
            }
            hasMoreMetadata = FlacMetadataReader.readMetadataBlock(dataInputStream, packetInputStream, trackInfoBuilder);
        }
        return trackInfoBuilder.build();
    }
}

