/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.client.requests.restaction.pagination.MentionPaginationAction;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Region;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.GuildVoiceState;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.managers.GuildController;
import net.dv8tion.jda.core.managers.GuildManager;
import net.dv8tion.jda.core.managers.GuildManagerUpdatable;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.restaction.pagination.AuditLogPaginationAction;
import net.dv8tion.jda.core.utils.cache.MemberCacheView;
import net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;

public interface Guild
extends ISnowflake {
    public RestAction<EnumSet<Region>> retrieveRegions();

    public String getName();

    public String getIconId();

    public String getIconUrl();

    public Set<String> getFeatures();

    public String getSplashId();

    public String getSplashUrl();

    @CheckReturnValue
    public RestAction<String> getVanityUrl();

    public VoiceChannel getAfkChannel();

    public TextChannel getSystemChannel();

    public Member getOwner();

    public Timeout getAfkTimeout();

    default public Region getRegion() {
        return Region.fromKey(this.getRegionRaw());
    }

    public String getRegionRaw();

    public boolean isMember(User var1);

    public Member getSelfMember();

    public Member getMember(User var1);

    default public Member getMemberById(String userId) {
        return this.getMemberCache().getElementById(userId);
    }

    default public Member getMemberById(long userId) {
        return this.getMemberCache().getElementById(userId);
    }

    default public List<Member> getMembers() {
        return this.getMemberCache().asList();
    }

    default public List<Member> getMembersByName(String name, boolean ignoreCase) {
        return this.getMemberCache().getElementsByUsername(name, ignoreCase);
    }

    default public List<Member> getMembersByNickname(String nickname, boolean ignoreCase) {
        return this.getMemberCache().getElementsByNickname(nickname, ignoreCase);
    }

    default public List<Member> getMembersByEffectiveName(String name, boolean ignoreCase) {
        return this.getMemberCache().getElementsByName(name, ignoreCase);
    }

    default public List<Member> getMembersWithRoles(Role ... roles) {
        return this.getMemberCache().getElementsWithRoles(roles);
    }

    default public List<Member> getMembersWithRoles(Collection<Role> roles) {
        return this.getMemberCache().getElementsWithRoles(roles);
    }

    public MemberCacheView getMemberCache();

    default public Category getCategoryById(String id) {
        return this.getCategoryCache().getElementById(id);
    }

    default public Category getCategoryById(long id) {
        return this.getCategoryCache().getElementById(id);
    }

    default public List<Category> getCategories() {
        return this.getCategoryCache().asList();
    }

    default public List<Category> getCategoriesByName(String name, boolean ignoreCase) {
        return this.getCategoryCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<Category> getCategoryCache();

    default public TextChannel getTextChannelById(String id) {
        return this.getTextChannelCache().getElementById(id);
    }

    default public TextChannel getTextChannelById(long id) {
        return this.getTextChannelCache().getElementById(id);
    }

    default public List<TextChannel> getTextChannels() {
        return this.getTextChannelCache().asList();
    }

    default public List<TextChannel> getTextChannelsByName(String name, boolean ignoreCase) {
        return this.getTextChannelCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<TextChannel> getTextChannelCache();

    default public VoiceChannel getVoiceChannelById(String id) {
        return this.getVoiceChannelCache().getElementById(id);
    }

    default public VoiceChannel getVoiceChannelById(long id) {
        return this.getVoiceChannelCache().getElementById(id);
    }

    default public List<VoiceChannel> getVoiceChannels() {
        return this.getVoiceChannelCache().asList();
    }

    default public List<VoiceChannel> getVoiceChannelsByName(String name, boolean ignoreCase) {
        return this.getVoiceChannelCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<VoiceChannel> getVoiceChannelCache();

    default public Role getRoleById(String id) {
        return this.getRoleCache().getElementById(id);
    }

    default public Role getRoleById(long id) {
        return this.getRoleCache().getElementById(id);
    }

    default public List<Role> getRoles() {
        return this.getRoleCache().asList();
    }

    default public List<Role> getRolesByName(String name, boolean ignoreCase) {
        return this.getRoleCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<Role> getRoleCache();

    default public Emote getEmoteById(String id) {
        return this.getEmoteCache().getElementById(id);
    }

    default public Emote getEmoteById(long id) {
        return this.getEmoteCache().getElementById(id);
    }

    default public List<Emote> getEmotes() {
        return this.getEmoteCache().asList();
    }

    default public List<Emote> getEmotesByName(String name, boolean ignoreCase) {
        return this.getEmoteCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<Emote> getEmoteCache();

    @Nonnull
    @CheckReturnValue
    public RestAction<List<Ban>> getBanList();

    @CheckReturnValue
    public RestAction<Integer> getPrunableMemberCount(int var1);

    public Role getPublicRole();

    @Nullable
    public TextChannel getDefaultChannel();

    public GuildManager getManager();

    @Deprecated
    public GuildManagerUpdatable getManagerUpdatable();

    public GuildController getController();

    @CheckReturnValue
    public MentionPaginationAction getRecentMentions();

    @CheckReturnValue
    public AuditLogPaginationAction getAuditLogs();

    @CheckReturnValue
    public RestAction<Void> leave();

    @CheckReturnValue
    public RestAction<Void> delete();

    @CheckReturnValue
    public RestAction<Void> delete(String var1);

    public AudioManager getAudioManager();

    public JDA getJDA();

    @CheckReturnValue
    public RestAction<List<Invite>> getInvites();

    @CheckReturnValue
    public RestAction<List<Webhook>> getWebhooks();

    public List<GuildVoiceState> getVoiceStates();

    public VerificationLevel getVerificationLevel();

    public NotificationLevel getDefaultNotificationLevel();

    public MFALevel getRequiredMFALevel();

    public ExplicitContentLevel getExplicitContentLevel();

    public boolean checkVerification();

    public boolean isAvailable();

    public static class Ban {
        protected final User user;
        protected final String reason;

        public Ban(User user, String reason) {
            this.user = user;
            this.reason = reason;
        }

        @Nonnull
        public User getUser() {
            return this.user;
        }

        @Nullable
        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return "GuildBan:" + this.user + (this.reason == null ? "" : '(' + this.reason + ')');
        }
    }

    public static enum ExplicitContentLevel {
        OFF(0, "Don't scan any messages."),
        NO_ROLE(1, "Scan messages from members without a role."),
        ALL(2, "Scan messages sent by all members."),
        UNKNOWN(-1, "Unknown filter level!");

        private final int key;
        private final String description;

        private ExplicitContentLevel(int key, String description) {
            this.key = key;
            this.description = description;
        }

        public int getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public static ExplicitContentLevel fromKey(int key) {
            for (ExplicitContentLevel level : ExplicitContentLevel.values()) {
                if (level.key != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }

    public static enum MFALevel {
        NONE(0),
        TWO_FACTOR_AUTH(1),
        UNKNOWN(-1);

        private final int key;

        private MFALevel(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static MFALevel fromKey(int key) {
            for (MFALevel level : MFALevel.values()) {
                if (level.getKey() != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }

    public static enum NotificationLevel {
        ALL_MESSAGES(0),
        MENTIONS_ONLY(1),
        UNKNOWN(-1);

        private final int key;

        private NotificationLevel(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static NotificationLevel fromKey(int key) {
            for (NotificationLevel level : NotificationLevel.values()) {
                if (level.getKey() != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }

    public static enum VerificationLevel {
        NONE(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        VERY_HIGH(4),
        UNKNOWN(-1);

        private final int key;

        private VerificationLevel(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static VerificationLevel fromKey(int key) {
            for (VerificationLevel level : VerificationLevel.values()) {
                if (level.getKey() != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }

    public static enum Timeout {
        SECONDS_60(60),
        SECONDS_300(300),
        SECONDS_900(900),
        SECONDS_1800(1800),
        SECONDS_3600(3600);

        private final int seconds;

        private Timeout(int seconds) {
            this.seconds = seconds;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public static Timeout fromKey(int seconds) {
            for (Timeout t : Timeout.values()) {
                if (t.getSeconds() != seconds) continue;
                return t;
            }
            throw new IllegalArgumentException("Provided key was not recognized. Seconds: " + seconds);
        }
    }
}

