/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.audio;

import com.sun.jna.ptr.PointerByReference;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.audio.AudioPacket;
import net.dv8tion.jda.core.audio.AudioReceiveHandler;
import net.dv8tion.jda.core.audio.AudioSendHandler;
import net.dv8tion.jda.core.audio.AudioWebSocket;
import net.dv8tion.jda.core.audio.CombinedAudio;
import net.dv8tion.jda.core.audio.Decoder;
import net.dv8tion.jda.core.audio.UserAudio;
import net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.core.audio.factory.IAudioSendSystem;
import net.dv8tion.jda.core.audio.factory.IPacketProvider;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.ExceptionEvent;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.utils.JDALogger;
import net.dv8tion.jda.core.utils.tuple.Pair;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.MDC;
import tomp2p.opuswrapper.Opus;

public class AudioConnection {
    public static final Logger LOG = JDALogger.getLog(AudioConnection.class);
    public static final int OPUS_SAMPLE_RATE = 48000;
    public static final int OPUS_FRAME_SIZE = 960;
    public static final int OPUS_FRAME_TIME_AMOUNT = 20;
    public static final int OPUS_CHANNEL_COUNT = 2;
    private final TIntLongMap ssrcMap = new TIntLongHashMap();
    private final TIntObjectMap<Decoder> opusDecoders = new TIntObjectHashMap<Decoder>();
    private final HashMap<User, Queue<Pair<Long, short[]>>> combinedQueue = new HashMap();
    private final String threadIdentifier;
    private final AudioWebSocket webSocket;
    private final ConcurrentMap<String, String> contextMap;
    private DatagramSocket udpSocket;
    private VoiceChannel channel;
    private volatile AudioSendHandler sendHandler = null;
    private volatile AudioReceiveHandler receiveHandler = null;
    private PointerByReference opusEncoder;
    private ScheduledExecutorService combinedAudioExecutor;
    private IAudioSendSystem sendSystem;
    private Thread receiveThread;
    private long queueTimeout;
    private volatile boolean couldReceive = false;
    private volatile boolean speaking = false;
    private volatile int silenceCounter = 0;
    private boolean sentSilenceOnConnect = false;
    private final byte[] silenceBytes = new byte[]{-8, -1, -2};

    public AudioConnection(AudioWebSocket webSocket, VoiceChannel channel) {
        this.channel = channel;
        this.webSocket = webSocket;
        this.webSocket.audioConnection = this;
        JDAImpl api = (JDAImpl)channel.getJDA();
        this.threadIdentifier = api.getIdentifierString() + " AudioConnection Guild: " + channel.getGuild().getId();
        this.contextMap = api.getContextMap();
    }

    public void ready() {
        Thread readyThread = new Thread(AudioManagerImpl.AUDIO_THREADS, () -> {
            if (this.contextMap != null) {
                MDC.setContextMap(this.contextMap);
            }
            long timeout = this.getGuild().getAudioManager().getConnectTimeout();
            long started = System.currentTimeMillis();
            boolean connectionTimeout = false;
            while (!this.webSocket.isReady()) {
                if (timeout > 0L && System.currentTimeMillis() - started > timeout) {
                    connectionTimeout = true;
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    LOG.error("AudioConnection ready thread got interrupted while sleeping", e);
                    Thread.currentThread().interrupt();
                }
            }
            if (!connectionTimeout) {
                this.udpSocket = this.webSocket.getUdpSocket();
                this.setupSendSystem();
                this.setupReceiveSystem();
            } else {
                this.webSocket.close(ConnectionStatus.ERROR_CONNECTION_TIMEOUT);
            }
        });
        readyThread.setUncaughtExceptionHandler((thread, throwable) -> {
            LOG.error("Uncaught exception in Audio ready-thread", throwable);
            JDAImpl api = (JDAImpl)this.getJDA();
            api.getEventManager().handle(new ExceptionEvent(api, throwable, true));
        });
        readyThread.setDaemon(true);
        readyThread.setName(this.threadIdentifier + " Ready Thread");
        readyThread.start();
    }

    public void setSendingHandler(AudioSendHandler handler) {
        this.sendHandler = handler;
        this.setupSendSystem();
    }

    public void setReceivingHandler(AudioReceiveHandler handler) {
        this.receiveHandler = handler;
        this.setupReceiveSystem();
    }

    public void setQueueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public VoiceChannel getChannel() {
        return this.channel;
    }

    public void setChannel(VoiceChannel channel) {
        this.channel = channel;
    }

    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public Guild getGuild() {
        return this.channel.getGuild();
    }

    public void removeUserSSRC(long userId) {
        AtomicInteger ssrcRef = new AtomicInteger(0);
        boolean modified = this.ssrcMap.retainEntries((ssrc, id) -> {
            boolean isEntry;
            boolean bl = isEntry = id == userId;
            if (isEntry) {
                ssrcRef.set(ssrc);
            }
            return !isEntry;
        });
        if (!modified) {
            return;
        }
        Decoder decoder = this.opusDecoders.remove(ssrcRef.get());
        if (decoder != null) {
            decoder.close();
        }
    }

    protected void updateUserSSRC(int ssrc, long userId) {
        if (this.ssrcMap.containsKey(ssrc)) {
            long previousId = this.ssrcMap.get(ssrc);
            if (previousId != userId) {
                LOG.error("Yeah.. So.. JDA received a UserSSRC update for an ssrc that already had a User set. Inform DV8FromTheWorld.\nChannelId: {} SSRC: {} oldId: {} newId: {}", this.channel.getId(), ssrc, previousId, userId);
            }
        } else {
            this.ssrcMap.put(ssrc, userId);
            if (this.receiveThread != null) {
                this.opusDecoders.put(ssrc, new Decoder(ssrc));
            }
        }
    }

    public void close(ConnectionStatus closeStatus) {
        this.shutdown();
        this.webSocket.close(closeStatus);
    }

    public synchronized void shutdown() {
        if (this.sendSystem != null) {
            this.sendSystem.shutdown();
            this.sendSystem = null;
        }
        if (this.receiveThread != null) {
            this.receiveThread.interrupt();
            this.receiveThread = null;
        }
        if (this.combinedAudioExecutor != null) {
            this.combinedAudioExecutor.shutdownNow();
            this.combinedAudioExecutor = null;
        }
        if (this.opusEncoder != null) {
            Opus.INSTANCE.opus_encoder_destroy(this.opusEncoder);
            this.opusEncoder = null;
        }
        this.opusDecoders.valueCollection().forEach(Decoder::close);
        this.opusDecoders.clear();
    }

    private synchronized void setupSendSystem() {
        if (this.udpSocket != null && !this.udpSocket.isClosed() && this.sendHandler != null && this.sendSystem == null) {
            IntBuffer error = IntBuffer.allocate(4);
            this.opusEncoder = Opus.INSTANCE.opus_encoder_create(48000, 2, 2049, error);
            IAudioSendFactory factory = ((JDAImpl)this.channel.getJDA()).getAudioSendFactory();
            this.sendSystem = factory.createSendSystem(new PacketProvider());
            this.sendSystem.setContextMap(this.contextMap);
            this.sendSystem.start();
        } else if (this.sendHandler == null && this.sendSystem != null) {
            this.sendSystem.shutdown();
            this.sendSystem = null;
            if (this.opusEncoder != null) {
                Opus.INSTANCE.opus_encoder_destroy(this.opusEncoder);
                this.opusEncoder = null;
            }
        }
    }

    private synchronized void setupReceiveSystem() {
        if (this.udpSocket != null && !this.udpSocket.isClosed() && this.receiveHandler != null && this.receiveThread == null) {
            this.setupReceiveThread();
        } else if (this.receiveHandler == null && this.receiveThread != null) {
            this.receiveThread.interrupt();
            this.receiveThread = null;
            if (this.combinedAudioExecutor != null) {
                this.combinedAudioExecutor.shutdownNow();
                this.combinedAudioExecutor = null;
            }
            this.opusDecoders.valueCollection().forEach(Decoder::close);
            this.opusDecoders.clear();
        } else if (this.receiveHandler != null && !this.receiveHandler.canReceiveCombined() && this.combinedAudioExecutor != null) {
            this.combinedAudioExecutor.shutdownNow();
            this.combinedAudioExecutor = null;
        }
    }

    private synchronized void setupReceiveThread() {
        if (this.receiveThread == null) {
            this.receiveThread = new Thread(AudioManagerImpl.AUDIO_THREADS, () -> {
                if (this.contextMap != null) {
                    MDC.setContextMap(this.contextMap);
                }
                try {
                    this.udpSocket.setSoTimeout(1000);
                }
                catch (SocketException e) {
                    LOG.error("Couldn't set SO_TIMEOUT for UDP socket", e);
                }
                while (!this.udpSocket.isClosed() && !Thread.currentThread().isInterrupted()) {
                    DatagramPacket receivedPacket = new DatagramPacket(new byte[1920], 1920);
                    try {
                        this.udpSocket.receive(receivedPacket);
                        if (this.receiveHandler != null && (this.receiveHandler.canReceiveUser() || this.receiveHandler.canReceiveCombined()) && this.webSocket.getSecretKey() != null) {
                            AudioPacket decryptedPacket;
                            if (!this.couldReceive) {
                                this.couldReceive = true;
                                this.sendSilentPackets();
                            }
                            if ((decryptedPacket = AudioPacket.decryptAudioPacket(receivedPacket, this.webSocket.getSecretKey())) == null) continue;
                            int ssrc = decryptedPacket.getSSRC();
                            long userId = this.ssrcMap.get(ssrc);
                            Decoder decoder = this.opusDecoders.get(ssrc);
                            if (userId == this.ssrcMap.getNoEntryValue()) {
                                byte[] audio = decryptedPacket.getEncodedAudio();
                                if (Arrays.equals(audio, this.silenceBytes)) continue;
                                LOG.debug("Received audio data with an unknown SSRC id. Ignoring");
                                continue;
                            }
                            if (decoder == null) {
                                decoder = new Decoder(ssrc);
                                this.opusDecoders.put(ssrc, decoder);
                            }
                            if (!decoder.isInOrder(decryptedPacket.getSequence())) {
                                LOG.trace("Got out-of-order audio packet. Ignoring.");
                                continue;
                            }
                            User user = this.getJDA().getUserById(userId);
                            if (user == null) {
                                LOG.warn("Received audio data with a known SSRC, but the userId associate with the SSRC is unknown to JDA!");
                                continue;
                            }
                            short[] decodedAudio = decoder.decodeFromOpus(decryptedPacket);
                            if (decodedAudio == null) continue;
                            if (this.receiveHandler.canReceiveUser()) {
                                this.receiveHandler.handleUserAudio(new UserAudio(user, decodedAudio));
                            }
                            if (!this.receiveHandler.canReceiveCombined()) continue;
                            Queue<Pair<Long, short[]>> queue = this.combinedQueue.get(user);
                            if (queue == null) {
                                queue = new ConcurrentLinkedQueue<Pair<Long, short[]>>();
                                this.combinedQueue.put(user, queue);
                            }
                            queue.add(Pair.of(System.currentTimeMillis(), decodedAudio));
                            continue;
                        }
                        if (!this.couldReceive) continue;
                        this.couldReceive = false;
                        this.sendSilentPackets();
                    }
                    catch (SocketTimeoutException decryptedPacket) {
                    }
                    catch (SocketException decryptedPacket) {
                    }
                    catch (Exception e) {
                        LOG.error("There was some random exception while waiting for udp packets", e);
                    }
                }
            });
            this.receiveThread.setUncaughtExceptionHandler((thread, throwable) -> {
                LOG.error("There was some uncaught exception in the audio receive thread", throwable);
                JDAImpl api = (JDAImpl)this.getJDA();
                api.getEventManager().handle(new ExceptionEvent(api, throwable, true));
            });
            this.receiveThread.setDaemon(true);
            this.receiveThread.setName(this.threadIdentifier + " Receiving Thread");
            this.receiveThread.start();
        }
        if (this.receiveHandler.canReceiveCombined()) {
            this.setupCombinedExecutor();
        }
    }

    private synchronized void setupCombinedExecutor() {
        if (this.combinedAudioExecutor == null) {
            this.combinedAudioExecutor = Executors.newSingleThreadScheduledExecutor(task -> {
                Runnable r = () -> {
                    if (this.contextMap != null) {
                        MDC.setContextMap(this.contextMap);
                    }
                    task.run();
                };
                Thread t = new Thread(AudioManagerImpl.AUDIO_THREADS, r, this.threadIdentifier + " Combined Thread");
                t.setDaemon(true);
                t.setUncaughtExceptionHandler((thread, throwable) -> {
                    LOG.error("I have no idea how, but there was an uncaught exception in the combinedAudioExecutor", throwable);
                    JDAImpl api = (JDAImpl)this.getJDA();
                    api.getEventManager().handle(new ExceptionEvent(api, throwable, true));
                });
                return t;
            });
            this.combinedAudioExecutor.scheduleAtFixedRate(() -> {
                try {
                    LinkedList<User> users = new LinkedList<User>();
                    LinkedList<short[]> audioParts = new LinkedList<short[]>();
                    if (this.receiveHandler != null && this.receiveHandler.canReceiveCombined()) {
                        long currentTime = System.currentTimeMillis();
                        for (Map.Entry<User, Queue<Pair<Long, short[]>>> entry : this.combinedQueue.entrySet()) {
                            User user = entry.getKey();
                            Queue<Pair<Long, short[]>> queue = entry.getValue();
                            if (queue.isEmpty()) continue;
                            Pair<Long, short[]> audioData = queue.poll();
                            while (audioData != null && currentTime - audioData.getLeft() > this.queueTimeout) {
                                audioData = queue.poll();
                            }
                            if (audioData == null) continue;
                            users.add(user);
                            audioParts.add(audioData.getRight());
                        }
                        if (!audioParts.isEmpty()) {
                            int audioLength = ((short[])audioParts.get(0)).length;
                            short[] mix = new short[1920];
                            for (int i = 0; i < audioLength; ++i) {
                                int sample = 0;
                                for (short[] audio : audioParts) {
                                    sample += audio[i];
                                }
                                mix[i] = sample > Short.MAX_VALUE ? Short.MAX_VALUE : (sample < Short.MIN_VALUE ? Short.MIN_VALUE : (short)sample);
                            }
                            this.receiveHandler.handleCombinedAudio(new CombinedAudio(users, mix));
                        } else {
                            this.receiveHandler.handleCombinedAudio(new CombinedAudio(Collections.emptyList(), new short[1920]));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("There was some unexpected exception in the combinedAudioExecutor!", e);
                }
            }, 0L, 20L, TimeUnit.MILLISECONDS);
        }
    }

    private byte[] encodeToOpus(byte[] rawAudio) {
        ShortBuffer nonEncodedBuffer = ShortBuffer.allocate(rawAudio.length / 2);
        ByteBuffer encoded = ByteBuffer.allocate(4096);
        for (int i = 0; i < rawAudio.length; i += 2) {
            int firstByte = 0xFF & rawAudio[i];
            int secondByte = 0xFF & rawAudio[i + 1];
            short toShort = (short)(firstByte << 8 | secondByte);
            nonEncodedBuffer.put(toShort);
        }
        ((Buffer)nonEncodedBuffer).flip();
        int result = Opus.INSTANCE.opus_encode(this.opusEncoder, nonEncodedBuffer, 960, encoded, encoded.capacity());
        byte[] audio = new byte[result];
        encoded.get(audio);
        return audio;
    }

    private void setSpeaking(boolean isSpeaking) {
        this.speaking = isSpeaking;
        JSONObject obj = new JSONObject().put("speaking", isSpeaking).put("delay", 0);
        this.webSocket.send(5, obj);
        if (!isSpeaking) {
            this.sendSilentPackets();
        }
    }

    private void sendSilentPackets() {
        this.silenceCounter = 0;
    }

    public AudioWebSocket getWebSocket() {
        return this.webSocket;
    }

    @Deprecated
    protected void finalize() throws Throwable {
        this.shutdown();
    }

    private class PacketProvider
    implements IPacketProvider {
        char seq = '\u0000';
        int timestamp = 0;

        private PacketProvider() {
        }

        @Override
        public String getIdentifier() {
            return AudioConnection.this.threadIdentifier;
        }

        @Override
        public VoiceChannel getConnectedChannel() {
            return AudioConnection.this.channel;
        }

        @Override
        public DatagramSocket getUdpSocket() {
            return AudioConnection.this.udpSocket;
        }

        @Override
        public DatagramPacket getNextPacket(boolean changeTalking) {
            DatagramPacket nextPacket = null;
            try {
                if (AudioConnection.this.sentSilenceOnConnect && AudioConnection.this.sendHandler != null && AudioConnection.this.sendHandler.canProvide()) {
                    AudioConnection.this.silenceCounter = -1;
                    byte[] rawAudio = AudioConnection.this.sendHandler.provide20MsAudio();
                    if (rawAudio == null || rawAudio.length == 0) {
                        if (AudioConnection.this.speaking && changeTalking) {
                            AudioConnection.this.setSpeaking(false);
                        }
                    } else {
                        if (!AudioConnection.this.sendHandler.isOpus()) {
                            rawAudio = AudioConnection.this.encodeToOpus(rawAudio);
                        }
                        AudioPacket packet = new AudioPacket(this.seq, this.timestamp, AudioConnection.this.webSocket.getSSRC(), rawAudio);
                        if (!AudioConnection.this.speaking) {
                            AudioConnection.this.setSpeaking(true);
                        }
                        nextPacket = packet.asEncryptedUdpPacket(AudioConnection.this.webSocket.getAddress(), AudioConnection.this.webSocket.getSecretKey());
                        this.seq = this.seq + '\u0001' > 65535 ? (char)'\u0000' : (char)(this.seq + '\u0001');
                    }
                } else if (AudioConnection.this.silenceCounter > -1) {
                    AudioPacket packet = new AudioPacket(this.seq, this.timestamp, AudioConnection.this.webSocket.getSSRC(), AudioConnection.this.silenceBytes);
                    nextPacket = packet.asEncryptedUdpPacket(AudioConnection.this.webSocket.getAddress(), AudioConnection.this.webSocket.getSecretKey());
                    this.seq = this.seq + '\u0001' > 65535 ? (char)'\u0000' : (char)(this.seq + '\u0001');
                    if (++AudioConnection.this.silenceCounter > 10) {
                        AudioConnection.this.silenceCounter = -1;
                        AudioConnection.this.sentSilenceOnConnect = true;
                    }
                } else if (AudioConnection.this.speaking && changeTalking) {
                    AudioConnection.this.setSpeaking(false);
                }
            }
            catch (Exception e) {
                LOG.error("There was an error while getting next audio packet", e);
            }
            if (nextPacket != null) {
                this.timestamp += 960;
            }
            return nextPacket;
        }

        @Override
        public void onConnectionError(ConnectionStatus status) {
            LOG.warn("IAudioSendSystem reported a connection error of: {}", (Object)status);
            LOG.warn("Shutting down AudioConnection.");
            AudioConnection.this.webSocket.close(status);
        }

        @Override
        public void onConnectionLost() {
            LOG.warn("Closing AudioConnection due to inability to send audio packets.");
            LOG.warn("Cannot send audio packet because JDA cannot navigate the route to Discord.\nAre you sure you have internet connection? It is likely that you've lost connection.");
            AudioConnection.this.webSocket.close(ConnectionStatus.ERROR_LOST_CONNECTION);
        }
    }
}

