/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.util;

import ch.njol.util.Validate;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.impl.DataMessage;
import org.eclipse.jdt.annotation.NonNull;

public class UpdatingMessage {
    private static final Map<String, Message> MESSAGE_MAP = new HashMap<String, Message>();
    private static final Map<String, WeakReference<UpdatingMessage>> UPDATING_MESSAGES = new HashMap<String, WeakReference<UpdatingMessage>>();
    private DataMessage dataMessage;
    private String ID;
    private boolean paused;

    private UpdatingMessage(@NonNull Message message) {
        Validate.notNull((Object[])new Object[]{message});
        if (message instanceof DataMessage) {
            this.dataMessage = (DataMessage)message;
        } else {
            this.ID = message.getId();
            MESSAGE_MAP.put(this.ID, message);
            UPDATING_MESSAGES.put(this.ID, new WeakReference<UpdatingMessage>(this));
        }
    }

    public static Message[] convert(UpdatingMessage[] updatingMessages) {
        if (updatingMessages == null) {
            return new Message[0];
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        for (UpdatingMessage updatingMessage : updatingMessages) {
            Message message = UpdatingMessage.convert(updatingMessage);
            if (message == null) continue;
            messages.add(message);
        }
        return messages.toArray(new Message[0]);
    }

    public static Message convert(UpdatingMessage updatingMessage) {
        if (updatingMessage == null) {
            return null;
        }
        return updatingMessage.getMessage();
    }

    public static void put(String ID, Message message) {
        Validate.notNull((Object[])new Object[]{ID, message});
        MESSAGE_MAP.put(ID, message);
    }

    public static boolean exists(String ID) {
        return UPDATING_MESSAGES.get(ID) != null;
    }

    public static UpdatingMessage getUpdatingMessage(String ID) {
        WeakReference<UpdatingMessage> message = UPDATING_MESSAGES.get(ID);
        return message == null ? null : (UpdatingMessage)message.get();
    }

    public static UpdatingMessage from(@NonNull Message message) {
        Validate.notNull((Object[])new Object[]{message});
        if (message instanceof DataMessage || MESSAGE_MAP.get(message.getId()) == null) {
            return new UpdatingMessage(message);
        }
        return (UpdatingMessage)UPDATING_MESSAGES.get(message.getId()).get();
    }

    public static UpdatingMessage from(String id) {
        if (UPDATING_MESSAGES.get(id) == null) {
            return null;
        }
        return (UpdatingMessage)UPDATING_MESSAGES.get(id).get();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void pause() {
        this.setPaused(true);
    }

    public void resume() {
        this.setPaused(false);
    }

    public String getID() {
        return this.ID;
    }

    public Message getMessage() {
        return this.dataMessage != null ? this.dataMessage : MESSAGE_MAP.get(this.ID);
    }

    protected void finalize() throws Throwable {
        MESSAGE_MAP.remove(this.getID());
    }
}

