/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.registration;

import ch.njol.skript.registrations.EventValues;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.registration.Registration;
import org.bukkit.event.Event;

public class Documentation {
    public static void setupSyntaxFile() {
        File file = new File(Vixio.getInstance().getDataFolder(), "Syntaxes.txt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            int i;
            StringBuilder builder;
            boolean multipleSyntax;
            FileWriter fw = new FileWriter(file, true);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("-=Conditions=-");
            bw.newLine();
            for (Registration reg : Vixio.getInstance().conditions) {
                boolean bl = multipleSyntax = reg.getSyntaxes().length == 2;
                if (multipleSyntax) {
                    builder = new StringBuilder();
                    builder.append("\tsyntax: {\"");
                    for (i = 0; i < reg.getSyntaxes().length; ++i) {
                        if (i + 1 == reg.getSyntaxes().length) {
                            builder.append(reg.getSyntaxes()[i] + "\"");
                            continue;
                        }
                        builder.append(reg.getSyntaxes()[i] + "\",");
                    }
                    builder.append("}");
                    bw.write(builder.toString());
                    bw.newLine();
                    continue;
                }
                bw.write("\tsyntax: " + reg.getSyntax());
                bw.newLine();
            }
            bw.write("-=Effects=-");
            bw.newLine();
            for (Registration reg : Vixio.getInstance().effects) {
                if (reg.getUserFacing() != null) {
                    bw.write("\tsyntax: " + reg.getUserFacing());
                    bw.newLine();
                    continue;
                }
                boolean bl = multipleSyntax = reg.getSyntaxes().length == 2;
                if (multipleSyntax) {
                    builder = new StringBuilder();
                    builder.append("\tsyntax: {\"");
                    for (i = 0; i < reg.getSyntaxes().length; ++i) {
                        if (i + 1 == reg.getSyntaxes().length) {
                            builder.append(reg.getSyntaxes()[i] + "\"");
                            continue;
                        }
                        builder.append(reg.getSyntaxes()[i] + "\",");
                    }
                    builder.append("}");
                    bw.write(builder.toString());
                    bw.newLine();
                    continue;
                }
                bw.write("\tsyntax: " + reg.getSyntax());
                bw.newLine();
            }
            bw.write("-=Expressions=-");
            bw.newLine();
            for (Registration reg : Vixio.getInstance().expressions) {
                boolean bl = multipleSyntax = reg.getSyntaxes().length == 2;
                if (reg.getUserFacing() != null) {
                    bw.write("\tsyntax: " + reg.getUserFacing());
                    bw.newLine();
                    continue;
                }
                if (multipleSyntax) {
                    builder = new StringBuilder();
                    builder.append("\tsyntax: {\"");
                    for (i = 0; i < reg.getSyntaxes().length; ++i) {
                        if (i + 1 == reg.getSyntaxes().length) {
                            builder.append(reg.getSyntaxes()[i] + "\"");
                            continue;
                        }
                        builder.append(reg.getSyntaxes()[i] + "\",");
                    }
                    builder.append("}");
                    bw.write(builder.toString());
                    bw.newLine();
                    continue;
                }
                bw.write("\tsyntax: " + reg.getSyntax());
                bw.newLine();
            }
            bw.write("-=Events=-");
            bw.newLine();
            for (Registration reg : Vixio.getInstance().events) {
                boolean bl = multipleSyntax = reg.getSyntaxes().length == 2;
                if (multipleSyntax) {
                    builder = new StringBuilder();
                    builder.append("\tsyntax: {\"");
                    for (i = 0; i < reg.getSyntaxes().length; ++i) {
                        if (i + 1 == reg.getSyntaxes().length) {
                            builder.append(reg.getSyntaxes()[i] + "\"");
                            continue;
                        }
                        builder.append(reg.getSyntaxes()[i] + "\",");
                    }
                    builder.append("}");
                    bw.write(builder.toString());
                    bw.newLine();
                    continue;
                }
                bw.write("\tsyntax: " + reg.getSyntax());
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateJson() {
        File file = new File(Vixio.getInstance().getDataFolder(), "syntaxes.json");
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileWriter fw = new FileWriter(file, true);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("\t{");
            bw.newLine();
            bw.write("\t\t\"effects\": [{");
            int effects = 0;
            for (Registration reg : Vixio.getInstance().effects) {
                ++effects;
                bw.newLine();
                bw.write("\t\t{");
                bw.newLine();
                bw.write("\t\t\t\"examples\": [");
                bw.newLine();
                bw.write("\t\t\t\t[\"" + reg.getExample() + "\"]");
                bw.newLine();
                bw.write("\t\t\t],");
                bw.newLine();
                bw.write("\t\t\t\"name\": \"" + reg.getName() + "\",");
                bw.newLine();
                bw.write("\t\t\t\"description\": \"" + reg.getDesc() + "\",");
                bw.newLine();
                bw.write("\t\t\t\"syntaxes\": [{");
                bw.newLine();
                if (reg.getUserFacing() != null) {
                    bw.write("\t\t\t\t\"syntax\": \"" + reg.getUserFacing() + "\"");
                    bw.newLine();
                } else {
                    boolean multipleSyntax;
                    boolean bl = multipleSyntax = reg.getSyntaxes().length == 2;
                    if (multipleSyntax) {
                        int multiSyntax = 0;
                        for (String syntax : reg.getSyntaxes()) {
                            if (++multiSyntax == 1) {
                                bw.write("\t\t\t\t\"syntax\": \"" + syntax + "\"");
                                bw.newLine();
                                bw.write("\t\t\t}, {");
                                bw.newLine();
                                continue;
                            }
                            if (multiSyntax != reg.getSyntaxes().length) {
                                bw.write("\t\t\t\t\"syntax\": \"" + syntax + "\"");
                                bw.newLine();
                                continue;
                            }
                            bw.write("\t\t\t\t\"syntax\": \"" + syntax + "\"");
                            bw.newLine();
                        }
                    } else {
                        bw.write("\t\t\t\t\"syntax\": \"" + reg.getSyntax() + "\"");
                        bw.newLine();
                    }
                }
                if (effects != Vixio.getInstance().effects.size()) {
                    bw.write("\t\t\t}],");
                    bw.newLine();
                    bw.write("\t\t},");
                    continue;
                }
                bw.write("\t\t\t}]");
                bw.newLine();
                bw.write("\t\t}");
            }
            bw.newLine();
            bw.write("\t\t}],");
            bw.newLine();
            bw.write("\t},");
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<String> getEventValues(Class<? extends Event> ... classes) {
        Method m = Documentation.getMethod(EventValues.class, "getEventValuesList", Integer.TYPE);
        List values = (List)Documentation.invokeMethod(m, null, 0);
        ArrayList<String> eventValues = new ArrayList<String>();
        if (values != null) {
            for (Class<? extends Event> c : classes) {
                for (Object eventValue : values) {
                    Class event = (Class)Documentation.getField(eventValue.getClass(), eventValue, "event");
                    if (event == null || !c.isAssignableFrom(event) && !event.isAssignableFrom(c)) continue;
                    Class ret = (Class)Documentation.getField(eventValue.getClass(), eventValue, "c");
                    eventValues.add("event-" + ret.getSimpleName().toLowerCase().replaceAll("updatingmessage", "message"));
                }
            }
        }
        return eventValues;
    }

    public static Method getMethod(Class<?> clz, String method, Class<?> ... parameters) {
        try {
            return clz.getDeclaredMethod(method, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T invokeMethod(Class<?> clz, String method, Object instance, Object ... parameters) {
        try {
            Class[] parameterTypes = new Class[parameters.length];
            int x = 0;
            for (Object obj : parameters) {
                parameterTypes[x++] = obj.getClass();
            }
            Method m = clz.getDeclaredMethod(method, parameterTypes);
            m.setAccessible(true);
            return (T)m.invoke(instance, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            method.setAccessible(true);
            return (T)method.invoke(instance, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T getField(Class<?> from, Object obj, String field) {
        try {
            Field f = from.getDeclaredField(field);
            f.setAccessible(true);
            return (T)f.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

