/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.org.apache.http.client.protocol;

import java.io.IOException;
import me.iblitzkriegi.vixio.org.apache.http.HttpEntity;
import me.iblitzkriegi.vixio.org.apache.http.HttpEntityEnclosingRequest;
import me.iblitzkriegi.vixio.org.apache.http.HttpException;
import me.iblitzkriegi.vixio.org.apache.http.HttpRequest;
import me.iblitzkriegi.vixio.org.apache.http.HttpRequestInterceptor;
import me.iblitzkriegi.vixio.org.apache.http.HttpVersion;
import me.iblitzkriegi.vixio.org.apache.http.ProtocolVersion;
import me.iblitzkriegi.vixio.org.apache.http.annotation.Contract;
import me.iblitzkriegi.vixio.org.apache.http.annotation.ThreadingBehavior;
import me.iblitzkriegi.vixio.org.apache.http.client.config.RequestConfig;
import me.iblitzkriegi.vixio.org.apache.http.client.protocol.HttpClientContext;
import me.iblitzkriegi.vixio.org.apache.http.protocol.HttpContext;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

