/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.embeds;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Date;
import ch.njol.util.Kleenean;
import java.time.Instant;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import net.dv8tion.jda.core.EmbedBuilder;
import org.bukkit.event.Event;

public class ExprEmbedTimestamp
extends SimplePropertyExpression<EmbedBuilder, Date> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        return true;
    }

    public Date convert(EmbedBuilder embed) {
        return embed.isEmpty() || embed.build().getTimestamp() == null ? null : Util.getDate(embed.build().getTimestamp());
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) && this.getExpr().isSingle()) {
            return new Class[]{Date.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        EmbedBuilder embed = (EmbedBuilder)this.getExpr().getSingle(e);
        if (embed == null) {
            return;
        }
        switch (mode) {
            case RESET: 
            case DELETE: {
                embed.setTimestamp(null);
                return;
            }
            case SET: {
                embed.setTimestamp(Instant.ofEpochMilli(((Date)delta[0]).getTimestamp()));
            }
        }
    }

    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    protected String getPropertyName() {
        return "timestamp of embed";
    }

    public String toString(Event e, boolean debug) {
        return "the timestamp of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprEmbedTimestamp.class, Date.class, "(timestamp|date)", "embedbuilders").setName("Timestamp of Embed").setDesc("Returns the timestamp of an embed. Can be set to any date (e.g. now).").setExample("set the timestamp of {_embed} to now", "", "# You can also set it to a date in the past/future like this", "", "set {_thePast} to now", "subtract 5 days from {_thePast}", "set the timestamp of {_embed} to {_thePast}");
    }
}

