/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.embeds;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.EmbedBuilder;
import net.dv8tion.jda.core.entities.MessageEmbed;
import org.bukkit.event.Event;

public class ExprEmbedAuthor
extends SimplePropertyExpression<EmbedBuilder, MessageEmbed.AuthorInfo> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        return true;
    }

    public MessageEmbed.AuthorInfo convert(EmbedBuilder embed) {
        return embed.isEmpty() ? null : embed.build().getAuthor();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return new Class[]{MessageEmbed.AuthorInfo.class, String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        EmbedBuilder[] embeds = (EmbedBuilder[])this.getExpr().getAll(e);
        if (embeds == null) {
            return;
        }
        switch (mode) {
            case SET: {
                for (EmbedBuilder embedBuilder : embeds) {
                    MessageEmbed.AuthorInfo author = delta[0] instanceof String ? new EmbedBuilder().setAuthor((String)delta[0]).build().getAuthor() : (MessageEmbed.AuthorInfo)delta[0];
                    embedBuilder.setAuthor(author.getName(), author.getUrl(), author.getIconUrl());
                }
                break;
            }
            case RESET: 
            case DELETE: {
                for (EmbedBuilder embedBuilder : embeds) {
                    embedBuilder.setAuthor(null, null, null);
                }
                break;
            }
        }
    }

    public Class<? extends MessageEmbed.AuthorInfo> getReturnType() {
        return MessageEmbed.AuthorInfo.class;
    }

    protected String getPropertyName() {
        return "author of embed";
    }

    public String toString(Event e, boolean debug) {
        return "the author of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprEmbedAuthor.class, MessageEmbed.AuthorInfo.class, "(author info|author)", "embedbuilders").setName("Author of Embed").setDesc("Returns the author of an embed. Can be set to any author.").setExample("set author of {_embed} to author named \"Pikachu\"");
    }
}

