/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.command;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import java.util.List;
import java.util.regex.MatchResult;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.commands.DiscordArgument;
import me.iblitzkriegi.vixio.commands.DiscordCommandEvent;
import me.iblitzkriegi.vixio.commands.DiscordCommandFactory;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class ExprArgument
extends SimpleExpression<Object> {
    private DiscordArgument<?> arg;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (!ScriptLoader.isCurrentEvent(DiscordCommandEvent.class)) {
            return false;
        }
        List<DiscordArgument<?>> currentArguments = DiscordCommandFactory.getInstance().currentArguments;
        if (currentArguments == null) {
            Skript.error((String)"The expression 'argument' can only be used within a command", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (currentArguments.size() == 0) {
            Skript.error((String)"This command doesn't have any arguments", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        DiscordArgument<?> arg = null;
        switch (matchedPattern) {
            case 0: {
                arg = currentArguments.get(currentArguments.size() - 1);
                break;
            }
            case 1: 
            case 2: {
                int i = Utils.parseInt((String)((MatchResult)parser.regexes.get(0)).group(1));
                if (i > currentArguments.size()) {
                    Skript.error((String)("The command doesn't have a " + StringUtils.fancyOrderNumber((int)i) + " argument"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    return false;
                }
                arg = currentArguments.get(i - 1);
                break;
            }
            case 3: {
                if (currentArguments.size() == 1) {
                    arg = currentArguments.get(0);
                    break;
                }
                Skript.error((String)"'argument(s)' cannot be used if the command has multiple arguments. Use 'argument 1', 'argument 2', etc. instead", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            case 4: 
            case 5: {
                ClassInfo c = (ClassInfo)((Literal)exprs[0]).getSingle();
                int num = parser.regexes.size() > 0 ? Utils.parseInt((String)((MatchResult)parser.regexes.get(0)).group()) : -1;
                int j = 1;
                for (DiscordArgument<?> a : currentArguments) {
                    if (!c.getC().isAssignableFrom(a.getType())) continue;
                    if (arg != null) {
                        Skript.error((String)("There are multiple " + c + " arguments in this command"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                        return false;
                    }
                    if (j < num) {
                        ++j;
                        continue;
                    }
                    arg = a;
                    if (j != num) continue;
                    break;
                }
                if (arg != null) break;
                if (num == -1 || --j == 0) {
                    Skript.error((String)("There is no " + c + " argument in this command"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                } else if (j == 1) {
                    Skript.error((String)("There is only one " + c + " argument in this command"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error((String)("There are only " + j + " " + c + " arguments in this command"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                }
                return false;
            }
            default: {
                assert (false) : matchedPattern;
                return false;
            }
        }
        assert (arg != null);
        this.arg = arg;
        return true;
    }

    @Nullable
    protected Object[] get(Event e) {
        return this.arg.getCurrent(e);
    }

    public Class<? extends Object> getReturnType() {
        return this.arg.getType();
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the " + StringUtils.fancyOrderNumber((int)(this.arg.getIndex() + 1)) + " argument";
        }
        return Classes.getDebugMessage((Object)this.getArray(e));
    }

    public boolean isSingle() {
        return this.arg.isSingle();
    }

    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("argument");
    }

    static {
        Vixio.getInstance().registerExpression(ExprArgument.class, Object.class, ExpressionType.SIMPLE, "[][the] last arg[ument][s]", "[][the] arg[ument][s](-| )<(\\d+)>", "[][the] <(\\d*1)st|(\\d*2)nd|(\\d*3)rd|(\\d*[4-90])th> arg[ument][s]", "[][the] arg[ument][s]", "[][the] %*classinfo%( |-)arg[ument][( |-)<\\d+>]", "[][the] arg[ument]( |-)%*classinfo%[( |-)<\\d+>]").setName("Argument").setDesc("Represents the argument of a command").setExample("discord command say <string>:", "\tprefixes: !, . and ;", "\ttrigger:", "\t\treply with arg-1 # replies with the first argument");
    }
}

