/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.channel;

import ch.njol.skript.classes.Changer;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.changers.ChangeableSimplePropertyExpression;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.exceptions.PermissionException;
import org.bukkit.event.Event;

public class ExprChannelLimit
extends ChangeableSimplePropertyExpression<Channel, Integer> {
    public Integer convert(Channel channel) {
        return channel instanceof VoiceChannel ? Integer.valueOf(((VoiceChannel)channel).getUserLimit()) : null;
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    protected String getPropertyName() {
        return "user limit";
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode, boolean vixioChanger) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{Number.class};
        }
        return null;
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        for (Channel channel : (Channel[])this.getExpr().getAll(e)) {
            if (!(channel instanceof VoiceChannel) || (channel = Util.bindVoiceChannel(bot, (VoiceChannel)channel)) == null) continue;
            try {
                channel.getManager().setUserLimit(mode == Changer.ChangeMode.DELETE ? 0 : ((Number)delta[0]).intValue()).queue();
            }
            catch (PermissionException ex) {
                Vixio.getErrorHandler().needsPerm(bot, mode.name().toLowerCase() + " user limit", ex.getPermission().getName());
            }
        }
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprChannelLimit.class, Integer.class, "user limit", "voicechannels/channels").setName("User limit of voice channel").setDesc("Get or sets the user limit of a voice channel").setUserFacing("[the] user limit[s] of %voicechannels%", "%voicechannels%'[s] user limit[s]").setExample("reply with \"%user limit of event-channel%\"");
    }
}

