/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.audio;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.audio.GuildMusicManager;
import me.iblitzkriegi.vixio.util.audio.TrackScheduler;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.entities.Guild;
import org.bukkit.event.Event;

public class ExprQueue
extends SimpleExpression<AudioTrack> {
    private Expression<Object> bot;
    private Expression<Guild> guild;

    protected AudioTrack[] get(Event e) {
        Guild guild = (Guild)this.guild.getSingle(e);
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        if (guild == null || bot == null) {
            return null;
        }
        GuildMusicManager musicManager = bot.getAudioManager(guild);
        TrackScheduler scheduler = musicManager.scheduler;
        if (scheduler.getQueue().isEmpty()) {
            return null;
        }
        ArrayList tracks = scheduler.getQueue();
        return tracks.toArray(new AudioTrack[tracks.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends AudioTrack> getReturnType() {
        return AudioTrack.class;
    }

    public String toString(Event e, boolean debug) {
        return "queue of " + this.bot.toString(e, debug) + " in " + this.guild.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.bot = exprs[0];
        this.guild = exprs[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET) {
            return new Class[0];
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Bot bot = Util.botFrom(this.bot.getSingle(e));
        if (bot != null) {
            bot.getAudioManager((Guild)((Guild)this.guild.getSingle((Event)e))).scheduler.resetPlayer();
        }
    }

    static {
        Vixio.getInstance().registerExpression(ExprQueue.class, AudioTrack.class, ExpressionType.SIMPLE, "queue of %bot/string% [in %guild%]").setName("Queue of bot").setDesc("Get all the tracks a bot currently has queued up for a guild.").setExample("set {var::*} to queue of event-bot in event-guild");
    }
}

