/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.commands;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.iblitzkriegi.vixio.commands.DiscordArgument;
import me.iblitzkriegi.vixio.commands.DiscordCommand;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.scope.EffectSection;
import net.dv8tion.jda.core.entities.ChannelType;
import org.bukkit.event.Event;

public class DiscordCommandFactory {
    private static final DiscordCommandFactory INSTANCE = new DiscordCommandFactory();
    private final Method PARSE_I;
    private final Pattern commandPattern = Pattern.compile("(?i)^(on )?discord command (\\S+)(\\s+(.+))?$");
    private final Pattern argumentPattern = Pattern.compile("<\\s*(?:(.+?)\\s*:\\s*)?(.+?)\\s*(?:=\\s*([^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?))?\\s*>");
    private final Pattern escape = Pattern.compile("[" + Pattern.quote("(|)<>%\\") + "]");
    private final String listPattern = "\\s*,\\s*|\\s+(and|or|, )\\s+";
    private final SectionValidator commandStructure = new SectionValidator().addEntry("usage", true).addEntry("description", true).addEntry("roles", true).addEntry("aliases", true).addEntry("prefixes", true).addEntry("bots", true).addEntry("executable in", true).addSection("trigger", false);
    public HashMap<String, DiscordCommand> commandMap = new HashMap();
    public List<DiscordArgument<?>> currentArguments;

    private DiscordCommandFactory() {
        Method _PARSE_I = null;
        try {
            _PARSE_I = SkriptParser.class.getDeclaredMethod("parse_i", String.class, Integer.TYPE, Integer.TYPE);
            _PARSE_I.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            Skript.error((String)"Skript's 'parse_i' method could not be resolved.");
        }
        this.PARSE_I = _PARSE_I;
    }

    public static DiscordCommandFactory getInstance() {
        return INSTANCE;
    }

    private String escape(String s) {
        return "" + this.escape.matcher(s).replaceAll("\\\\$0");
    }

    public boolean parseArguments(String args, DiscordCommand command, Event event) {
        SkriptParser parser = new SkriptParser(args, 2, ParseContext.COMMAND);
        SkriptParser.ParseResult res = null;
        try {
            res = (SkriptParser.ParseResult)this.PARSE_I.invoke((Object)parser, command.getPattern(), 0, 0);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (res == null) {
            return false;
        }
        List<DiscordArgument<?>> as = command.getArguments();
        assert (as.size() == res.exprs.length);
        for (int i = 0; i < res.exprs.length; ++i) {
            if (res.exprs[i] == null) {
                as.get(i).setToDefault(event);
                continue;
            }
            as.get(i).set(event, res.exprs[i].getArray(event));
        }
        return true;
    }

    public ArrayList<ChannelType> parsePlaces(String[] places) {
        ArrayList<ChannelType> types = new ArrayList<ChannelType>();
        for (String place : places) {
            if (Util.equalsAnyIgnoreCase(place, "server", "guild")) {
                types.add(ChannelType.TEXT);
                continue;
            }
            if (Util.equalsAnyIgnoreCase(place, "dm", "pm", "direct message", "private message")) {
                types.add(ChannelType.PRIVATE);
                continue;
            }
            Skript.error((String)("'executable in' should be either 'guild', 'dm', or both, but found '" + place + "'"));
            return null;
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscordCommand add(SectionNode node) {
        DiscordCommand discordCommand;
        String arguments;
        String command = node.getKey();
        if (command == null) {
            return null;
        }
        Matcher matcher = this.commandPattern.matcher(command = ScriptLoader.replaceOptions((String)command));
        if (!matcher.matches()) {
            return null;
        }
        int level = 0;
        for (int i = 0; i < command.length(); ++i) {
            if (command.charAt(i) == '[') {
                ++level;
                continue;
            }
            if (command.charAt(i) != ']') continue;
            if (level == 0) {
                Skript.error((String)"Invalid placement of [optional brackets]");
                return null;
            }
            --level;
        }
        if (level > 0) {
            Skript.error((String)"Invalid amount of [optional brackets]");
            return null;
        }
        command = matcher.group(2);
        DiscordCommand existingCommand = this.commandMap.get(command);
        if (existingCommand != null) {
            File script = existingCommand.getScript();
            Skript.error((String)("A discord command with the name \"" + existingCommand.getName() + "\" is already defined" + (script == null ? "" : " in " + script.getName())));
        }
        if ((arguments = matcher.group(4)) == null) {
            arguments = "";
        }
        StringBuilder pattern = new StringBuilder();
        this.currentArguments = new ArrayList();
        ArrayList currentArguments = this.currentArguments;
        Matcher m = this.argumentPattern.matcher(arguments);
        int lastEnd = 0;
        int optionals = 0;
        int i = 0;
        while (m.find()) {
            pattern.append(this.escape("" + arguments.substring(lastEnd, m.start())));
            optionals += StringUtils.count((String)arguments, (char)'[', (int)lastEnd, (int)m.start());
            optionals -= StringUtils.count((String)arguments, (char)']', (int)lastEnd, (int)m.start());
            lastEnd = m.end();
            ClassInfo c = Classes.getClassInfoFromUserInput((String)("" + m.group(2)));
            NonNullPair p = Utils.getEnglishPlural((String)("" + m.group(2)));
            if (c == null) {
                c = Classes.getClassInfoFromUserInput((String)((String)p.getFirst()));
            }
            if (c == null) {
                Skript.error((String)("Unknown type '" + m.group(2) + "'"));
                return null;
            }
            Parser parser = c.getParser();
            if (parser == null || !parser.canParse(ParseContext.COMMAND)) {
                Skript.error((String)("Can't use " + c + " as argument of a command"));
                return null;
            }
            DiscordArgument arg = DiscordArgument.newInstance(m.group(1), c, m.group(3), i, (Boolean)p.getSecond() == false, optionals > 0);
            if (arg == null) {
                return null;
            }
            currentArguments.add(arg);
            if (arg.isOptional() && optionals == 0) {
                pattern.append('[');
                ++optionals;
            }
            pattern.append("%" + (arg.isOptional() ? "-" : "") + Utils.toEnglishPlural((String)c.getCodeName(), (boolean)((Boolean)p.getSecond())) + "%");
            ++i;
        }
        pattern.append(this.escape("" + arguments.substring(lastEnd)));
        optionals += StringUtils.count((String)arguments, (char)'[', (int)lastEnd);
        optionals -= StringUtils.count((String)arguments, (char)']', (int)lastEnd);
        for (i = 0; i < optionals; ++i) {
            pattern.append(']');
        }
        node.convertToEntries(0);
        if (!this.commandStructure.validate((Node)node)) {
            return null;
        }
        if (!(node.get("trigger") instanceof SectionNode)) {
            return null;
        }
        SectionNode trigger = (SectionNode)node.get("trigger");
        String usage = ScriptLoader.replaceOptions((String)node.get("usage", ""));
        String description = ScriptLoader.replaceOptions((String)node.get("description", ""));
        String aliasesString = ScriptLoader.replaceOptions((String)node.get("aliases", ""));
        List<String> aliases = aliasesString.isEmpty() ? null : Arrays.asList(aliasesString.split("\\s*,\\s*|\\s+(and|or|, )\\s+"));
        ArrayList<Expression<String>> prefixes = new ArrayList<Expression<String>>();
        String rawPrefixes = ScriptLoader.replaceOptions((String)node.get("prefixes", ""));
        if (rawPrefixes.isEmpty()) {
            if (command.length() == 1) {
                prefixes.add((Expression<String>)new SimpleLiteral((Object)"", false));
            } else {
                prefixes.add((Expression<String>)new SimpleLiteral((Object)String.valueOf(command.charAt(0)), false));
                command = command.substring(1);
            }
        } else {
            for (String prefix : rawPrefixes.split("\\s*,\\s*|\\s+(and|or|, )\\s+")) {
                if (!prefix.equals("%") && !prefix.equals("%%") && prefix.startsWith("%") && prefix.endsWith("%")) {
                    VariableString p = VariableString.newInstance((String)prefix, (StringMode)StringMode.MESSAGE);
                    if (p == null) {
                        return null;
                    }
                    prefixes.add((Expression<String>)p);
                    continue;
                }
                prefixes.add((Expression<String>)new SimpleLiteral((Object)prefix, false));
            }
        }
        String roleString = ScriptLoader.replaceOptions((String)node.get("roles", ""));
        List<String> roles = roleString.isEmpty() ? null : Arrays.asList(roleString.split("\\s*,\\s*|\\s+(and|or|, )\\s+"));
        String botString = ScriptLoader.replaceOptions((String)node.get("bots", ""));
        List<String> bots = botString.isEmpty() ? null : Arrays.asList(botString.split("\\s*,\\s*|\\s+(and|or|, )\\s+"));
        ArrayList<ChannelType> places = this.parsePlaces(ScriptLoader.replaceOptions((String)node.get("executable in", "guild, dm")).split("\\s*,\\s*|\\s+(and|or|, )\\s+"));
        if (places == null) {
            return null;
        }
        RetainingLogHandler errors = SkriptLogger.startRetainingLog();
        this.currentArguments = currentArguments;
        try {
            discordCommand = new DiscordCommand(node.getConfig().getFile(), command, pattern.toString(), currentArguments, prefixes, aliases, description, usage, roles, places, bots, ScriptLoader.loadItems((SectionNode)trigger));
        }
        finally {
            this.currentArguments = null;
            EffectSection.stopLog(errors);
        }
        this.commandMap.put(command, discordCommand);
        currentArguments = null;
        return discordCommand;
    }

    public boolean remove(String name) {
        return this.commandMap.remove(name) != null;
    }

    public Collection<DiscordCommand> getCommands() {
        return this.commandMap.values();
    }
}

