/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeCipherOperation;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeCipherOperationType;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSignatureCipher;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.iblitzkriegi.vixio.org.apache.commons.io.IOUtils;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import me.iblitzkriegi.vixio.org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeSignatureCipherManager {
    private static final Logger log = LoggerFactory.getLogger(YoutubeSignatureCipherManager.class);
    private static final String VARIABLE_PART = "[a-zA-Z_\\$][a-zA-Z_0-9]*";
    private static final String VARIABLE_PART_DEFINE = "\\\"?[a-zA-Z_\\$][a-zA-Z_0-9]*\\\"?";
    private static final String BEFORE_ACCESS = "(?:\\[\\\"|\\.)";
    private static final String AFTER_ACCESS = "(?:\\\"\\]|)";
    private static final String VARIABLE_PART_ACCESS = "(?:\\[\\\"|\\.)[a-zA-Z_\\$][a-zA-Z_0-9]*(?:\\\"\\]|)";
    private static final String REVERSE_PART = ":function\\(a\\)\\{(?:return )?a\\.reverse\\(\\)\\}";
    private static final String SLICE_PART = ":function\\(a,b\\)\\{return a\\.slice\\(b\\)\\}";
    private static final String SPLICE_PART = ":function\\(a,b\\)\\{a\\.splice\\(0,b\\)\\}";
    private static final String SWAP_PART = ":function\\(a,b\\)\\{var c=a\\[0\\];a\\[0\\]=a\\[b%a\\.length\\];a\\[b(?:%a.length|)\\]=c(?:;return a)?\\}";
    private static final Pattern functionPattern = Pattern.compile("function(?: [a-zA-Z_\\$][a-zA-Z_0-9]*)?\\(a\\)\\{a=a\\.split\\(\"\"\\);\\s*((?:(?:a=)?[a-zA-Z_\\$][a-zA-Z_0-9]*(?:\\[\\\"|\\.)[a-zA-Z_\\$][a-zA-Z_0-9]*(?:\\\"\\]|)\\(a,\\d+\\);)+)return a\\.join\\(\"\"\\)\\}");
    private static final Pattern actionsPattern = Pattern.compile("var ([a-zA-Z_\\$][a-zA-Z_0-9]*)=\\{((?:(?:\\\"?[a-zA-Z_\\$][a-zA-Z_0-9]*\\\"?:function\\(a\\)\\{(?:return )?a\\.reverse\\(\\)\\}|\\\"?[a-zA-Z_\\$][a-zA-Z_0-9]*\\\"?:function\\(a,b\\)\\{return a\\.slice\\(b\\)\\}|\\\"?[a-zA-Z_\\$][a-zA-Z_0-9]*\\\"?:function\\(a,b\\)\\{a\\.splice\\(0,b\\)\\}|\\\"?[a-zA-Z_\\$][a-zA-Z_0-9]*\\\"?:function\\(a,b\\)\\{var c=a\\[0\\];a\\[0\\]=a\\[b%a\\.length\\];a\\[b(?:%a.length|)\\]=c(?:;return a)?\\}),?\\n?)+)\\};");
    private static final String PATTERN_PREFIX = "(?:^|,)\\\"?([a-zA-Z_\\$][a-zA-Z_0-9]*)\\\"?";
    private static final Pattern reversePattern = Pattern.compile("(?:^|,)\\\"?([a-zA-Z_\\$][a-zA-Z_0-9]*)\\\"?:function\\(a\\)\\{(?:return )?a\\.reverse\\(\\)\\}", 8);
    private static final Pattern slicePattern = Pattern.compile("(?:^|,)\\\"?([a-zA-Z_\\$][a-zA-Z_0-9]*)\\\"?:function\\(a,b\\)\\{return a\\.slice\\(b\\)\\}", 8);
    private static final Pattern splicePattern = Pattern.compile("(?:^|,)\\\"?([a-zA-Z_\\$][a-zA-Z_0-9]*)\\\"?:function\\(a,b\\)\\{a\\.splice\\(0,b\\)\\}", 8);
    private static final Pattern swapPattern = Pattern.compile("(?:^|,)\\\"?([a-zA-Z_\\$][a-zA-Z_0-9]*)\\\"?:function\\(a,b\\)\\{var c=a\\[0\\];a\\[0\\]=a\\[b%a\\.length\\];a\\[b(?:%a.length|)\\]=c(?:;return a)?\\}", 8);
    private static final Pattern signatureExtraction = Pattern.compile("/s/([^/]+)/");
    private final ConcurrentMap<String, YoutubeSignatureCipher> cipherCache = new ConcurrentHashMap<String, YoutubeSignatureCipher>();
    private final Set<String> dumpedScriptUrls = new HashSet<String>();
    private final Object cipherLoadLock = new Object();

    public URI getValidUrl(HttpInterface httpInterface, String playerScript, YoutubeTrackFormat format) throws IOException {
        String signature = format.getSignature();
        URI initialUrl = format.getUrl();
        if (signature == null) {
            return initialUrl;
        }
        YoutubeSignatureCipher cipher = this.getCipherKeyFromScript(httpInterface, playerScript);
        try {
            return new URIBuilder(initialUrl).addParameter("ratebypass", "yes").addParameter("signature", cipher.apply(signature)).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getValidDashUrl(HttpInterface httpInterface, String playerScript, String dashUrl) throws IOException {
        Matcher matcher = signatureExtraction.matcher(dashUrl);
        if (!matcher.find()) {
            return dashUrl;
        }
        YoutubeSignatureCipher cipher = this.getCipherKeyFromScript(httpInterface, playerScript);
        return matcher.replaceFirst("/signature/" + cipher.apply(matcher.group(1)) + "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YoutubeSignatureCipher getCipherKeyFromScript(HttpInterface httpInterface, String cipherScriptUrl) throws IOException {
        YoutubeSignatureCipher cipherKey = (YoutubeSignatureCipher)this.cipherCache.get(cipherScriptUrl);
        if (cipherKey == null) {
            Object object = this.cipherLoadLock;
            synchronized (object) {
                log.debug("Parsing cipher from player script {}.", (Object)cipherScriptUrl);
                try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(YoutubeSignatureCipherManager.parseTokenScriptUrl(cipherScriptUrl)));){
                    this.validateResponseCode(response);
                    cipherKey = this.extractTokensFromScript(IOUtils.toString(response.getEntity().getContent(), "UTF-8"), cipherScriptUrl);
                    this.cipherCache.put(cipherScriptUrl, cipherKey);
                }
            }
        }
        return cipherKey;
    }

    private void validateResponseCode(CloseableHttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new IOException("Received non-success response code " + statusCode);
        }
    }

    private List<String> getQuotedFunctions(String ... functionNames) {
        return Stream.of(functionNames).filter(function -> function != null).map(Pattern::quote).collect(Collectors.toList());
    }

    private void dumpProblematicScript(String script, String sourceUrl, String issue) {
        if (!this.dumpedScriptUrls.add(sourceUrl)) {
            return;
        }
        try {
            Path path = Files.createTempFile("lavaplayer-yt-player-script", ".js", new FileAttribute[0]);
            Files.write(path, script.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            log.error("Problematic YouTube player script {} detected (issue detected with script: {}). Dumped to {}.", sourceUrl, issue, path.toAbsolutePath());
        }
        catch (Exception e) {
            log.error("Failed to dump problematic YouTube player script {} (issue detected with script: {})", (Object)sourceUrl, (Object)issue);
        }
    }

    private YoutubeSignatureCipher extractTokensFromScript(String script, String sourceUrl) {
        Matcher actions = actionsPattern.matcher(script);
        if (!actions.find()) {
            this.dumpProblematicScript(script, sourceUrl, "no actions match");
            throw new IllegalStateException("Must find action functions from script: " + sourceUrl);
        }
        String actionBody = actions.group(2);
        String reverseKey = YoutubeSignatureCipherManager.extractDollarEscapedFirstGroup(reversePattern, actionBody);
        String slicePart = YoutubeSignatureCipherManager.extractDollarEscapedFirstGroup(slicePattern, actionBody);
        String splicePart = YoutubeSignatureCipherManager.extractDollarEscapedFirstGroup(splicePattern, actionBody);
        String swapKey = YoutubeSignatureCipherManager.extractDollarEscapedFirstGroup(swapPattern, actionBody);
        Pattern extractor = Pattern.compile("(?:a=)?" + Pattern.quote(actions.group(1)) + BEFORE_ACCESS + "(" + String.join((CharSequence)"|", this.getQuotedFunctions(reverseKey, slicePart, splicePart, swapKey)) + ")" + AFTER_ACCESS + "\\(a,(\\d+)\\)");
        Matcher functions = functionPattern.matcher(script);
        if (!functions.find()) {
            this.dumpProblematicScript(script, sourceUrl, "no decipher function match");
            throw new IllegalStateException("Must find decipher function from script.");
        }
        Matcher matcher = extractor.matcher(functions.group(1));
        YoutubeSignatureCipher cipherKey = new YoutubeSignatureCipher();
        while (matcher.find()) {
            String type = matcher.group(1);
            if (type.equals(swapKey)) {
                cipherKey.addOperation(new YoutubeCipherOperation(YoutubeCipherOperationType.SWAP, Integer.parseInt(matcher.group(2))));
                continue;
            }
            if (type.equals(reverseKey)) {
                cipherKey.addOperation(new YoutubeCipherOperation(YoutubeCipherOperationType.REVERSE, 0));
                continue;
            }
            if (type.equals(slicePart)) {
                cipherKey.addOperation(new YoutubeCipherOperation(YoutubeCipherOperationType.SLICE, Integer.parseInt(matcher.group(2))));
                continue;
            }
            if (type.equals(splicePart)) {
                cipherKey.addOperation(new YoutubeCipherOperation(YoutubeCipherOperationType.SPLICE, Integer.parseInt(matcher.group(2))));
                continue;
            }
            this.dumpProblematicScript(script, sourceUrl, "unknown cipher operation found");
        }
        if (cipherKey.isEmpty()) {
            log.error("No operations detected from cipher extracted from {}.", (Object)sourceUrl);
            this.dumpProblematicScript(script, sourceUrl, "no cipher operations");
        }
        return cipherKey;
    }

    private static String extractDollarEscapedFirstGroup(Pattern pattern, String text) {
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1).replace("$", "\\$") : null;
    }

    private static URI parseTokenScriptUrl(String urlString) {
        try {
            if (urlString.startsWith("//")) {
                return new URI("https:" + urlString);
            }
            if (urlString.startsWith("/")) {
                return new URI("https://s.ytimg.com" + urlString);
            }
            return new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

