/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.stream;

import com.sedmelluq.discord.lavaplayer.source.stream.ExtendedM3uParser;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import me.iblitzkriegi.vixio.org.apache.commons.io.IOUtils;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;

public abstract class M3uStreamSegmentUrlProvider {
    protected static String createSegmentUrl(String playlistUrl, String segmentName) {
        return URI.create(playlistUrl).resolve(segmentName).toString();
    }

    protected abstract String getQualityFromM3uDirective(ExtendedM3uParser.Line var1);

    protected abstract String getNextSegmentUrl(HttpInterface var1);

    public InputStream getNextSegmentStream(HttpInterface httpInterface) {
        String url = this.getNextSegmentUrl(httpInterface);
        if (url == null) {
            return null;
        }
        CloseableHttpResponse response = null;
        boolean success = false;
        try {
            response = httpInterface.execute(TwitchStreamAudioSourceManager.createGetRequest(url));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code from segment data URL: " + statusCode);
            }
            success = true;
            InputStream inputStream = response.getEntity().getContent();
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (response != null && !success) {
                IOUtils.closeQuietly((Closeable)response);
            }
        }
    }

    protected List<ChannelStreamInfo> loadChannelStreamsList(String[] lines) throws IOException {
        ExtendedM3uParser.Line streamInfoLine = null;
        ArrayList<ChannelStreamInfo> streams = new ArrayList<ChannelStreamInfo>();
        for (String lineText : lines) {
            ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(lineText);
            if (line.isData() && streamInfoLine != null) {
                String quality = this.getQualityFromM3uDirective(streamInfoLine);
                if (quality != null) {
                    streams.add(new ChannelStreamInfo(quality, line.lineData));
                }
                streamInfoLine = null;
                continue;
            }
            if (!line.isDirective() || !"EXT-X-STREAM-INF".equals(line.directiveName)) continue;
            streamInfoLine = line;
        }
        return streams;
    }

    protected List<String> loadStreamSegmentsList(HttpInterface httpInterface, String streamSegmentPlaylistUrl) throws IOException {
        ArrayList<String> segments = new ArrayList<String>();
        for (String lineText : HttpClientTools.fetchResponseLines(httpInterface, new HttpGet(streamSegmentPlaylistUrl), "stream segments list")) {
            ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(lineText);
            if (!line.isData()) continue;
            segments.add(line.lineData);
        }
        return segments;
    }

    protected String chooseNextSegment(List<String> segments, String lastSegment) {
        String current;
        String selected = null;
        for (int i = segments.size() - 1; i >= 0 && !(current = segments.get(i)).equals(lastSegment); --i) {
            selected = current;
        }
        return selected;
    }

    protected static class ChannelStreamInfo {
        public final String quality;
        public final String url;

        private ChannelStreamInfo(String quality, String url) {
            this.quality = quality;
            this.url = url;
        }
    }
}

