/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter.volume;

import com.sedmelluq.discord.lavaplayer.filter.volume.PcmVolumeProcessor;
import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkDecoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.OpusChunkDecoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.OpusChunkEncoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.PcmChunkDecoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.PcmChunkEncoder;
import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameRebuilder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class AudioFrameVolumeChanger
implements AudioFrameRebuilder {
    private final AudioConfiguration configuration;
    private final AudioDataFormat format;
    private final int newVolume;
    private final ShortBuffer sampleBuffer;
    private final PcmVolumeProcessor volumeProcessor;
    private AudioChunkEncoder encoder;
    private AudioChunkDecoder decoder;
    private int frameIndex;

    private AudioFrameVolumeChanger(AudioConfiguration configuration, AudioDataFormat format, int newVolume) {
        this.configuration = configuration;
        this.format = format;
        this.newVolume = newVolume;
        this.sampleBuffer = ByteBuffer.allocateDirect(format.bufferSize(2)).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.volumeProcessor = new PcmVolumeProcessor(100);
    }

    @Override
    public AudioFrame rebuild(AudioFrame frame) {
        if (frame.volume == this.newVolume) {
            return frame;
        }
        this.decoder.decode(frame.data, this.sampleBuffer);
        int targetVolume = this.newVolume;
        if (++this.frameIndex < 50) {
            targetVolume = (int)((double)(this.newVolume - frame.volume) * ((double)this.frameIndex / 50.0) + (double)frame.volume);
        }
        if (targetVolume != 0) {
            this.volumeProcessor.applyVolume(frame.volume, targetVolume, this.sampleBuffer);
        }
        byte[] bytes = this.encoder.encode(this.sampleBuffer);
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return new AudioFrame(frame.timecode, bytes, targetVolume, this.format);
    }

    private void setupLibraries() {
        if (this.format.codec == AudioDataFormat.Codec.OPUS) {
            this.encoder = new OpusChunkEncoder(this.configuration, this.format);
            this.decoder = new OpusChunkDecoder(this.format);
        } else {
            this.encoder = new PcmChunkEncoder(this.format);
            this.decoder = new PcmChunkDecoder(this.format);
        }
    }

    private void clearLibraries() {
        if (this.encoder != null) {
            this.encoder.close();
        }
        if (this.decoder != null) {
            this.decoder.close();
        }
    }

    public static void apply(AudioProcessingContext context) {
        AudioFrameVolumeChanger volumeChanger = new AudioFrameVolumeChanger(context.configuration, context.outputFormat, context.volumeLevel.get());
        try {
            volumeChanger.setupLibraries();
            context.frameConsumer.rebuild(volumeChanger);
        }
        finally {
            volumeChanger.clearLibraries();
        }
    }
}

