/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.hooks;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.Event;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.hooks.SubscribeEvent;

public class AnnotatedEventManager
implements IEventManager {
    private final Set<Object> listeners = new HashSet<Object>();
    private final Map<Class<? extends Event>, Map<Object, List<Method>>> methods = new HashMap<Class<? extends Event>, Map<Object, List<Method>>>();

    @Override
    public void register(Object listener) {
        if (this.listeners.add(listener)) {
            this.updateMethods();
        }
    }

    @Override
    public void unregister(Object listener) {
        if (this.listeners.remove(listener)) {
            this.updateMethods();
        }
    }

    @Override
    public List<Object> getRegisteredListeners() {
        return Collections.unmodifiableList(new LinkedList<Object>(this.listeners));
    }

    @Override
    public void handle(Event event) {
        Class<?> eventClass = event.getClass();
        do {
            Map<Object, List<Method>> listeners;
            if ((listeners = this.methods.get(eventClass)) == null) continue;
            listeners.entrySet().forEach(e -> ((List)e.getValue()).forEach(method -> {
                try {
                    method.setAccessible(true);
                    method.invoke(e.getKey(), event);
                }
                catch (IllegalAccessException | InvocationTargetException e1) {
                    JDAImpl.LOG.error("Couldn't access annotated eventlistener method", e1);
                }
                catch (Throwable throwable) {
                    JDAImpl.LOG.error("One of the EventListeners had an uncaught exception", throwable);
                }
            }));
        } while ((eventClass = eventClass == Event.class ? null : eventClass.getSuperclass()) != null);
    }

    private void updateMethods() {
        this.methods.clear();
        for (Object listener : this.listeners) {
            Method[] allMethods;
            boolean isClass = listener instanceof Class;
            Class<?> c = isClass ? (Class<?>)listener : listener.getClass();
            for (Method m : allMethods = c.getDeclaredMethods()) {
                Class<?>[] pType;
                if (!m.isAnnotationPresent(SubscribeEvent.class) || isClass && !Modifier.isStatic(m.getModifiers()) || (pType = m.getParameterTypes()).length != 1 || !Event.class.isAssignableFrom(pType[0])) continue;
                Class<?> eventClass = pType[0];
                if (!this.methods.containsKey(eventClass)) {
                    this.methods.put(eventClass, new HashMap());
                }
                if (!this.methods.get(eventClass).containsKey(listener)) {
                    this.methods.get(eventClass).put(listener, new ArrayList());
                }
                this.methods.get(eventClass).get(listener).add(m);
            }
        }
    }
}

