/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.audit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.audit.ActionType;
import net.dv8tion.jda.core.audit.AuditLogChange;
import net.dv8tion.jda.core.audit.AuditLogKey;
import net.dv8tion.jda.core.audit.AuditLogOption;
import net.dv8tion.jda.core.audit.TargetType;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.utils.Checks;

public class AuditLogEntry
implements ISnowflake {
    protected final long id;
    protected final long targetId;
    protected final GuildImpl guild;
    protected final UserImpl user;
    protected final String reason;
    protected final Map<String, AuditLogChange> changes;
    protected final Map<String, Object> options;
    protected final ActionType type;

    public AuditLogEntry(ActionType type, long id, long targetId, GuildImpl guild, UserImpl user, String reason, Map<String, AuditLogChange> changes, Map<String, Object> options) {
        this.type = type;
        this.id = id;
        this.targetId = targetId;
        this.guild = guild;
        this.user = user;
        this.reason = reason;
        this.changes = changes != null && !changes.isEmpty() ? Collections.unmodifiableMap(changes) : Collections.emptyMap();
        this.options = options != null && !options.isEmpty() ? Collections.unmodifiableMap(options) : Collections.emptyMap();
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public long getTargetIdLong() {
        return this.targetId;
    }

    public String getTargetId() {
        return Long.toUnsignedString(this.targetId);
    }

    public Guild getGuild() {
        return this.guild;
    }

    public User getUser() {
        return this.user;
    }

    public String getReason() {
        return this.reason;
    }

    public JDA getJDA() {
        return this.guild.getJDA();
    }

    public Map<String, AuditLogChange> getChanges() {
        return this.changes;
    }

    public AuditLogChange getChangeByKey(AuditLogKey key) {
        return key == null ? null : this.getChangeByKey(key.getKey());
    }

    public AuditLogChange getChangeByKey(String key) {
        return this.changes.get(key);
    }

    public List<AuditLogChange> getChangesForKeys(AuditLogKey ... keys) {
        Checks.notNull(keys, "Keys");
        ArrayList<AuditLogChange> changes = new ArrayList<AuditLogChange>(keys.length);
        for (AuditLogKey key : keys) {
            AuditLogChange change = this.getChangeByKey(key);
            if (change == null) continue;
            changes.add(change);
        }
        return Collections.unmodifiableList(changes);
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public <T> T getOptionByName(String name) {
        return (T)this.options.get(name);
    }

    public <T> T getOption(AuditLogOption option) {
        Checks.notNull((Object)option, "Option");
        return this.getOptionByName(option.getKey());
    }

    public List<Object> getOptions(AuditLogOption ... options) {
        Checks.notNull(options, "Options");
        ArrayList items = new ArrayList(options.length);
        for (AuditLogOption option : options) {
            Object obj = this.getOption(option);
            if (obj == null) continue;
            items.add(obj);
        }
        return Collections.unmodifiableList(items);
    }

    public ActionType getType() {
        return this.type;
    }

    public TargetType getTargetType() {
        return this.type.getTargetType();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AuditLogEntry)) {
            return false;
        }
        AuditLogEntry other = (AuditLogEntry)obj;
        return other.id == this.id && other.targetId == this.targetId;
    }

    public String toString() {
        return "ALE:" + (Object)((Object)this.type) + "(ID:" + this.id + " / TID:" + this.targetId + " / " + this.guild + ')';
    }
}

