/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.util.audio;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.events.base.TrackEvent;
import me.iblitzkriegi.vixio.util.audio.MusicStorage;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class TrackScheduler
extends AudioEventAdapter {
    private final AudioPlayer player;
    private final BlockingQueue<AudioTrack> queue;

    public TrackScheduler(AudioPlayer player) {
        this.player = player;
        this.queue = new LinkedBlockingQueue<AudioTrack>();
    }

    public void queue(AudioTrack track) {
        if (!this.player.startTrack(track, true)) {
            this.queue.offer(track);
        }
    }

    public void nextTrack() {
        this.player.startTrack((AudioTrack)this.queue.poll(), false);
    }

    @Override
    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
        MusicStorage musicStorage;
        if (endReason.mayStartNext) {
            this.nextTrack();
        }
        if ((musicStorage = Vixio.getInstance().musicStorage.get(player)) != null) {
            Bukkit.getPluginManager().callEvent((Event)new TrackEvent(TrackEvent.TrackState.END, musicStorage.getBot(), musicStorage.getGuild(), track));
        }
    }

    public AudioPlayer getPlayer() {
        return this.player;
    }

    public void resetPlayer() {
        this.queue.clear();
    }

    @Override
    public void onTrackStart(AudioPlayer player, AudioTrack track) {
        MusicStorage musicStorage = Vixio.getInstance().musicStorage.get(player);
        if (musicStorage != null) {
            Bukkit.getPluginManager().callEvent((Event)new TrackEvent(TrackEvent.TrackState.START, musicStorage.getBot(), musicStorage.getGuild(), track));
        }
    }

    public ArrayList getQueue() {
        return new ArrayList<AudioTrack>(this.queue);
    }
}

