/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.guild;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.List;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Role;
import org.bukkit.event.Event;

public class ExprRoleNamed
extends SimpleExpression<Role> {
    private Expression<Guild> guild;
    private Expression<String> name;
    private boolean isSingle;

    protected Role[] get(Event e) {
        Guild guild = (Guild)this.guild.getSingle(e);
        String name = (String)this.name.getSingle(e);
        if (guild == null || name == null || name.isEmpty()) {
            return null;
        }
        try {
            List<Role> roles = guild.getRolesByName(name, false);
            if (roles.size() > 1) {
                this.isSingle = false;
                return roles.toArray(new Role[roles.size()]);
            }
            return new Role[]{roles.get(0)};
        }
        catch (IndexOutOfBoundsException | NullPointerException x) {
            return null;
        }
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<? extends Role> getReturnType() {
        return Role.class;
    }

    public String toString(Event e, boolean debug) {
        return "role named " + this.name.toString(e, debug) + " in guild ";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.guild = exprs[1];
        return true;
    }

    static {
        Vixio.getInstance().registerExpression(ExprRoleNamed.class, Role.class, ExpressionType.SIMPLE, "role[s] named %string% [in %guild%]").setName("Role named").setDesc("Get a role via it's name in a Guild! The guild may be assumed in events.").setExample("role[s] named \"Owner\"");
    }
}

